/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.api.container.Sniffer;
import org.glassfish.internal.data.EngineInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ContainerRegistry {
    @Inject
    Habitat habitat;
    Map<String, EngineInfo> containers = new HashMap<String, EngineInfo>();

    public synchronized void addContainer(String name, EngineInfo info) {
        this.containers.put(name, info);
        info.setRegistry(this);
    }

    public List<Sniffer> getStartedContainersSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (EngineInfo info : this.getContainers()) {
            sniffers.add(info.getSniffer());
        }
        return sniffers;
    }

    public synchronized EngineInfo getContainer(String containerType) {
        return this.containers.get(containerType);
    }

    public synchronized EngineInfo removeContainer(EngineInfo container) {
        for (Map.Entry<String, EngineInfo> entry : this.containers.entrySet()) {
            if (!entry.getValue().equals(container)) continue;
            return this.containers.remove(entry.getKey());
        }
        return null;
    }

    public Iterable<EngineInfo> getContainers() {
        ArrayList<EngineInfo> copy = new ArrayList<EngineInfo>(this.containers.size());
        copy.addAll(this.containers.values());
        return copy;
    }
}

