/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.sun.enterprise.container.common.spi.util.GlassFishInputStreamHandler;
import com.sun.enterprise.container.common.spi.util.SerializableObjectFactory;
import com.sun.enterprise.naming.util.ObjectInputOutputStreamFactory;
import com.sun.enterprise.naming.util.ObjectInputOutputStreamFactoryFactory;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

class GlassFishObjectInputStream
extends ObjectInputStream {
    private ClassLoader appLoader;
    private static Logger _logger = LogDomains.getLogger(GlassFishObjectInputStream.class, (String)"javax.enterprise.system.core.naming");
    private ObjectInputOutputStreamFactory inputStreamHelper;
    private Collection<GlassFishInputStreamHandler> handlers;

    GlassFishObjectInputStream(Collection<GlassFishInputStreamHandler> handlers, InputStream in, ClassLoader appCl, boolean resolve) throws IOException, StreamCorruptedException {
        super(in);
        this.appLoader = appCl;
        this.handlers = handlers;
        if (resolve) {
            this.enableResolveObject(resolve);
        }
        this.inputStreamHelper = ObjectInputOutputStreamFactoryFactory.getFactory();
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        Object result = obj;
        try {
            if (obj instanceof SerializableObjectFactory) {
                return ((SerializableObjectFactory)obj).createObject();
            }
            for (GlassFishInputStreamHandler handler : this.handlers) {
                Object r = handler.resolveObject(obj);
                if (r == null) continue;
                result = r == GlassFishInputStreamHandler.NULL_OBJECT ? null : r;
                break;
            }
            return result;
        }
        catch (IOException ioEx) {
            _logger.log(Level.SEVERE, "ejb.resolve_object_exception", ioEx);
            throw ioEx;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "ejb.resolve_object_exception", ex);
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> cl = Class.forName(interfaces[i], false, this.appLoader);
            if ((cl.getModifiers() & 1) == 0) {
                return super.resolveProxyClass(interfaces);
            }
            classObjs[i] = cl;
        }
        try {
            return Proxy.getProxyClass(this.appLoader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class<?> clazz = this.inputStreamHelper.resolveClass((ObjectInputStream)this, desc);
        if (clazz == null) {
            try {
                clazz = this.appLoader.loadClass(desc.getName());
            }
            catch (ClassNotFoundException e) {
                clazz = super.resolveClass(desc);
            }
        }
        return clazz;
    }
}

