/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.sun.enterprise.container.common.impl.util.SerializableJNDIContext;
import com.sun.enterprise.container.common.spi.util.GlassFishOutputStreamHandler;
import com.sun.enterprise.container.common.spi.util.IndirectlySerializable;
import com.sun.enterprise.naming.util.ObjectInputOutputStreamFactory;
import com.sun.enterprise.naming.util.ObjectInputOutputStreamFactoryFactory;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.Logger;
import javax.naming.Context;

class GlassFishObjectOutputStream
extends ObjectOutputStream {
    private static Logger _logger = LogDomains.getLogger(GlassFishObjectOutputStream.class, (String)"javax.enterprise.system.core.naming");
    static final int EJBID_OFFSET = 0;
    static final int INSTANCEKEYLEN_OFFSET = 8;
    static final int INSTANCEKEY_OFFSET = 12;
    private static final byte HOME_KEY = -1;
    private ObjectInputOutputStreamFactory outputStreamHelper;
    private Collection<GlassFishOutputStreamHandler> handlers;

    GlassFishObjectOutputStream(Collection<GlassFishOutputStreamHandler> handlers, OutputStream out, boolean replaceObject) throws IOException {
        super(out);
        this.handlers = handlers;
        if (replaceObject) {
            this.enableReplaceObject(replaceObject);
        }
        this.outputStreamHelper = ObjectInputOutputStreamFactoryFactory.getFactory();
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        Object result = obj;
        if (obj instanceof IndirectlySerializable) {
            result = ((IndirectlySerializable)obj).getSerializableObjectFactory();
        } else if (obj instanceof Context) {
            result = new SerializableJNDIContext((Context)obj);
        } else {
            for (GlassFishOutputStreamHandler handler : this.handlers) {
                Object r = handler.replaceObject(obj);
                if (r == null) continue;
                result = r;
                break;
            }
        }
        return result;
    }

    @Override
    protected void annotateClass(Class<?> cl) throws IOException {
        this.outputStreamHelper.annotateClass((ObjectOutputStream)this, cl);
    }
}

