/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.MultiLruCache;
import com.sun.enterprise.util.CULoggerInfo;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class BoundedMultiLruCache
extends MultiLruCache {
    protected long maxSize = Long.MAX_VALUE;
    protected long currentSize;
    private Object currentSizeLk = new Object();

    @Override
    public void init(int maxCapacity, Properties props) throws Exception {
        super.init(maxCapacity, props);
        this.currentSize = 0L;
        if (props != null) {
            String strMaxSize = props.getProperty("MaxSize");
            int multiplier = 1;
            long size = -1L;
            String prop = strMaxSize;
            if (prop != null) {
                int index = (prop = prop.toUpperCase(Locale.ENGLISH)).indexOf("KB");
                if (index != -1) {
                    multiplier = 1024;
                    prop = prop.substring(0, index);
                } else {
                    index = prop.indexOf("MB");
                    if (index != -1) {
                        multiplier = 0x100000;
                        prop = prop.substring(0, index);
                    }
                }
                try {
                    size = Long.parseLong(prop.trim());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (size > 0L) {
                this.maxSize = size * (long)multiplier;
            } else {
                String msg = CULoggerInfo.getString("NCLS-COMUTIL-00009");
                Object[] params = new Object[]{strMaxSize};
                msg = MessageFormat.format(msg, params);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    @Override
    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem item) {
        MultiLruCache.LruCacheItem overflow = (MultiLruCache.LruCacheItem)super.itemAdded(item);
        if (overflow != null) {
            this.decrementCurrentSize(overflow.getSize());
        }
        this.incrementCurrentSize(item.getSize());
        return overflow;
    }

    @Override
    protected void itemRefreshed(BaseCache.CacheItem item, int oldSize) {
        super.itemRefreshed(item, oldSize);
        this.decrementCurrentSize(oldSize);
        this.incrementCurrentSize(item.getSize());
    }

    @Override
    protected void itemRemoved(BaseCache.CacheItem item) {
        super.itemRemoved(item);
        this.decrementCurrentSize(item.getSize());
    }

    @Override
    protected boolean isThresholdReached() {
        return this.currentSize > this.maxSize || super.isThresholdReached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementCurrentSize(int size) {
        Object object = this.currentSizeLk;
        synchronized (object) {
            this.currentSize += (long)size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void decrementCurrentSize(int size) {
        Object object = this.currentSizeLk;
        synchronized (object) {
            this.currentSize -= (long)size;
        }
    }

    @Override
    public Object getStatByName(String key) {
        Object stat = super.getStatByName(key);
        if (stat == null && key != null) {
            if (key.equals("cache.BoundedMultiLruCache.stat_currentSize")) {
                stat = this.currentSize;
            } else if (key.equals("cache.BoundedMultiLruCache.stat_maxSize")) {
                stat = this.maxSize == Long.MAX_VALUE ? "default" : Long.valueOf(this.maxSize);
            }
        }
        return stat;
    }

    @Override
    public Map getStats() {
        Map stats = super.getStats();
        stats.put("cache.BoundedMultiLruCache.stat_currentSize", this.currentSize);
        if (this.maxSize == Long.MAX_VALUE) {
            stats.put("cache.BoundedMultiLruCache.stat_maxSize", "default");
        } else {
            stats.put("cache.BoundedMultiLruCache.stat_maxSize", this.maxSize);
        }
        return stats;
    }
}

