/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import com.sun.enterprise.util.CULoggerInfo;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.BytecodePreprocessor;

public class PreprocessorUtil {
    private static boolean _preprocessorEnabled = false;
    private static BytecodePreprocessor[] _preprocessor;

    public static boolean init(String[] ppClassNames) {
        if (ppClassNames != null) {
            PreprocessorUtil.setupPreprocessor(ppClassNames);
        }
        return _preprocessorEnabled;
    }

    public static byte[] processClass(String className, byte[] classBytes) {
        Logger _logger = CULoggerInfo.getLogger();
        byte[] goodBytes = classBytes;
        if (_preprocessorEnabled && _preprocessor != null) {
            for (int i = 0; i < _preprocessor.length; ++i) {
                classBytes = _preprocessor[i].preprocess(className, classBytes);
                _logger.log(Level.FINE, "[PreprocessorUtil.processClass] Preprocessor {0} Processed Class: {1}", new Object[]{i, className});
                if (classBytes != null) {
                    goodBytes = classBytes;
                    continue;
                }
                _logger.log(Level.SEVERE, "NCLS-COMUTIL-0001", new String[]{className, _preprocessor[i].getClass().getName()});
                if (i == 0) {
                    _logger.log(Level.SEVERE, "NCLS-COMUTIL-0002", className);
                    continue;
                }
                _logger.log(Level.SEVERE, "NCLS-COMUTIL-0003", className);
            }
        }
        return goodBytes;
    }

    private static synchronized void setupPreprocessor(String[] ppClassNames) {
        Logger _logger = CULoggerInfo.getLogger();
        if (_preprocessor != null) {
            return;
        }
        try {
            _preprocessor = new BytecodePreprocessor[ppClassNames.length];
            for (int i = 0; i < ppClassNames.length; ++i) {
                String ppClassName = ppClassNames[i].trim();
                Class<?> ppClass = Class.forName(ppClassName);
                if (ppClass != null) {
                    PreprocessorUtil._preprocessor[i] = (BytecodePreprocessor)ppClass.newInstance();
                    _preprocessorEnabled = true;
                }
                if (_preprocessor[i] != null) {
                    if (_preprocessor[i].initialize(new Hashtable())) continue;
                    _logger.log(Level.SEVERE, "NCLS-COMUTIL-0006", ppClassName);
                    _logger.log(Level.SEVERE, "NCLS-COMUTIL-0005");
                    _preprocessorEnabled = false;
                    continue;
                }
                _logger.log(Level.SEVERE, "NCLS-COMUTIL-0006", ppClassName);
                _logger.log(Level.SEVERE, "NCLS-COMUTIL-0005");
                _preprocessorEnabled = false;
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "NCLS-COMUTIL-0007", t);
            _logger.log(Level.SEVERE, "NCLS-COMUTIL-0005");
            _preprocessorEnabled = false;
        }
    }

    public static boolean isPreprocessorEnabled() {
        return _preprocessorEnabled;
    }
}

