/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.collections;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestUtils {
    public static final String EOL_TOKEN = "%%%EOL%%%";
    public static final String MAIN_ATTS = "main";
    public static final String EOL = System.getProperty("line.separator");

    public static final Map<String, Map<String, String>> normalize(Manifest m) {
        HashMap<String, Map<String, String>> all = new HashMap<String, Map<String, String>>();
        Attributes mainAtt = m.getMainAttributes();
        all.put(MAIN_ATTS, ManifestUtils.normalize(mainAtt));
        Map<String, Attributes> unwashed = m.getEntries();
        Set<Map.Entry<String, Attributes>> entries = unwashed.entrySet();
        for (Map.Entry<String, Attributes> entry : entries) {
            String name = entry.getKey();
            Attributes value = entry.getValue();
            if (name == null || value == null) continue;
            all.put(name, ManifestUtils.normalize(value));
        }
        return all;
    }

    public static final Map<String, String> normalize(Attributes att) {
        Set<Map.Entry<Object, Object>> entries = att.entrySet();
        HashMap<String, String> pristine = new HashMap<String, String>(entries.size());
        for (Map.Entry<Object, Object> entry : entries) {
            String key = entry.getKey().toString();
            String value = ManifestUtils.decode(entry.getValue().toString());
            if (key == null) continue;
            pristine.put(key, value);
        }
        return pristine;
    }

    public static final String encode(String s) {
        s = s.replaceAll("\r\n", EOL_TOKEN);
        return s.replaceAll("\n", EOL_TOKEN);
    }

    public static Map<String, String> getMain(Map<String, Map<String, String>> exManifest) {
        Map<String, String> map = exManifest.get(MAIN_ATTS);
        if (map == null) {
            map = new HashMap<String, String>(0);
        }
        return map;
    }

    public static String decode(String s) {
        if (s == null || s.equals("null")) {
            return null;
        }
        return s.replaceAll(EOL_TOKEN, EOL);
    }

    private ManifestUtils() {
    }
}

