/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.InstallNodeBaseCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.util.cluster.windows.io.RemoteFileCopyProgress;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFile;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileSystem;
import com.sun.enterprise.util.cluster.windows.process.WindowsCredentials;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import com.sun.enterprise.util.cluster.windows.process.WindowsRemoteScripter;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="install-node-dcom")
@PerLookup
public class InstallNodeDcomCommand
extends InstallNodeBaseCommand {
    @Param(name="windowsuser", shortName="w", optional=true, defaultValue="${user.name}")
    private String user;
    @Param(name="windowsdomain", shortName="d", optional=true, defaultValue="")
    private String windowsDomain;
    private final List<HostAndPassword> passwords = new ArrayList<HostAndPassword>();
    private String remoteInstallDirString;

    @Override
    protected void validate() throws CommandException {
        super.validate();
        for (String host : this.hosts) {
            if (!NetUtils.isThisHostLocal((String)host)) continue;
            throw new CommandException(Strings.get("install.node.nolocal", host));
        }
    }

    @Override
    final String getRawRemoteUser() {
        return this.user;
    }

    @Override
    int getRawRemotePort() {
        return 135;
    }

    @Override
    String getSshKeyFile() {
        return null;
    }

    @Override
    void copyToHosts(File zipFile, ArrayList<String> binDirFiles) throws CommandException {
        try {
            this.copyToHostsInternal(zipFile, binDirFiles);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (WindowsException ex) {
            throw new CommandException((Throwable)ex);
        }
    }

    @Override
    final void precopy() throws CommandException {
        this.remoteInstallDirString = this.getInstallDir().replace('/', '\\');
        try {
            for (String host : this.hosts) {
                WindowsRemoteFileSystem wrfs;
                WindowsRemoteFile remoteInstallDir;
                String remotePassword = this.getWindowsPassword(host);
                this.passwords.add(new HostAndPassword(host, remotePassword));
                if (this.getForce() || !(remoteInstallDir = new WindowsRemoteFile(wrfs = new WindowsRemoteFileSystem(host, this.getRemoteUser(), remotePassword), this.remoteInstallDirString)).exists()) continue;
                throw new CommandException(Strings.get("install.dir.exists", remoteInstallDir));
            }
        }
        catch (WindowsException ex) {
            throw new CommandException((Throwable)ex);
        }
    }

    private void copyToHostsInternal(File zipFile, ArrayList<String> binDirFiles) throws CommandException, WindowsException {
        String zipFileName = "glassfish_install.zip";
        String unpackScriptName = "unpack.bat";
        for (String host : this.hosts) {
            String remotePassword = this.getPassword(host);
            WindowsRemoteFileSystem wrfs = new WindowsRemoteFileSystem(host, this.getRemoteUser(), remotePassword);
            WindowsRemoteFile remoteInstallDir = new WindowsRemoteFile(wrfs, this.remoteInstallDirString);
            remoteInstallDir.mkdirs(this.getForce());
            WindowsRemoteFile remoteZip = new WindowsRemoteFile(remoteInstallDir, "glassfish_install.zip");
            WindowsRemoteFile unpackScript = new WindowsRemoteFile(remoteInstallDir, "unpack.bat");
            System.out.printf("Copying %d bytes", zipFile.length());
            remoteZip.copyFrom(zipFile, new RemoteFileCopyProgress(){

                public void callback(long numcopied, long numtotal) {
                    System.out.print(".");
                }

                public int getChunkSize() {
                    return 0x100000;
                }
            });
            System.out.println("");
            String fullZipFileName = this.remoteInstallDirString + "\\" + "glassfish_install.zip";
            String fullUnpackScriptPath = this.remoteInstallDirString + "\\" + "unpack.bat";
            unpackScript.copyFrom(this.makeScriptString(this.remoteInstallDirString, "glassfish_install.zip"));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("WROTE FILE TO REMOTE SYSTEM: " + fullZipFileName + " and " + fullUnpackScriptPath);
            }
            this.unpackOnHosts(host, remotePassword, fullUnpackScriptPath.replace('/', '\\'));
        }
    }

    private String makeScriptString(String windowsInstallDir, String zipFileName) {
        StringBuilder scriptString = new StringBuilder(windowsInstallDir.substring(0, 2));
        scriptString.append("\r\n").append("cd \"").append(windowsInstallDir).append("\"\r\n").append("jar xvf ").append(zipFileName).append("\r\n");
        return scriptString.toString();
    }

    private void unpackOnHosts(String host, String remotePassword, String unpackScript) throws WindowsException, CommandException {
        WindowsCredentials bonafides;
        WindowsRemoteScripter scripter;
        String out;
        String domain = this.windowsDomain;
        if (!InstallNodeDcomCommand.ok((String)domain)) {
            domain = host;
        }
        if ((out = (scripter = new WindowsRemoteScripter(bonafides = new WindowsCredentials(host, domain, this.getRemoteUser(), remotePassword))).run(unpackScript)) == null || out.length() < 50) {
            throw new CommandException(Strings.get("dcom.error.unpacking", unpackScript, out));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Output from Windows Unpacker:\n" + out);
        }
    }

    private String getPassword(String host) {
        if (!InstallNodeDcomCommand.ok((String)host)) {
            return null;
        }
        for (HostAndPassword hap : this.passwords) {
            if (!host.equals(hap.host)) continue;
            return hap.password;
        }
        return null;
    }

    private static class HostAndPassword {
        private final String host;
        private final String password;

        public HostAndPassword(String host, String password) {
            this.host = host;
            this.password = password;
        }
    }
}

