/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.util.cluster.RemoteType;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFile;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileSystem;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import com.trilead.ssh2.SFTPv3FileAttributes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.DcomInfo;
import org.glassfish.hk2.api.ServiceLocator;

public abstract class SecureAdminBootstrapHelper {
    private static final String DOMAIN_XML_PATH = "config/domain.xml";
    private static final String[] SECURE_ADMIN_FILE_REL_URIS_TO_COPY = new String[]{"config/domain.xml", "config/keystore.jks", "config/cacerts.jks"};
    private static final String[] SECURE_ADMIN_FILE_DIRS_TO_CREATE = new String[]{"config"};

    public static SecureAdminBootstrapHelper getRemoteHelper(ServiceLocator habitat, File DASInstanceDir, String remoteNodeDir, String instance, Node node, Logger logger) throws BootstrapException {
        RemoteType type = null;
        try {
            type = RemoteType.valueOf((String)node.getType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(Strings.get("internal.error", "unknown type"));
        }
        switch (type) {
            case SSH: {
                return new SSHHelper(habitat, DASInstanceDir, remoteNodeDir, instance, node, logger);
            }
            case DCOM: {
                return new DCOMHelper(habitat, DASInstanceDir, remoteNodeDir, instance, node, logger);
            }
        }
        throw new IllegalArgumentException(Strings.get("internal.error", "A new type must have been added --> unknown type: " + type.toString()));
    }

    public static SecureAdminBootstrapHelper getLocalHelper(File existingInstanceDir, File newInstanceDir) {
        return new LocalHelper(existingInstanceDir, newInstanceDir);
    }

    protected abstract void mkdirs(String var1) throws IOException;

    protected abstract void close();

    protected abstract void copyBootstrapFiles() throws FileNotFoundException, IOException;

    protected abstract void backdateInstanceDomainXML() throws BootstrapException;

    public void bootstrapInstance() throws BootstrapException {
        try {
            this.mkdirs();
            this.copyBootstrapFiles();
            this.backdateInstanceDomainXML();
        }
        catch (Exception ex) {
            throw new BootstrapException(ex);
        }
    }

    private void mkdirs() throws IOException {
        for (String dirPath : SECURE_ADMIN_FILE_DIRS_TO_CREATE) {
            this.mkdirs(dirPath);
        }
    }

    public static class BootstrapException
    extends Exception {
        private final transient SSHLauncher launcher;

        public BootstrapException(SSHLauncher launcher, Exception ex) {
            super(ex);
            this.launcher = launcher;
        }

        public BootstrapException(Exception ex) {
            super(ex);
            this.launcher = null;
        }

        public BootstrapException(String msg) {
            super(msg);
            this.launcher = null;
        }

        public String sshSettings() {
            return this.launcher != null ? this.launcher.toString() : "";
        }
    }

    private static class LocalHelper
    extends SecureAdminBootstrapHelper {
        private final URI existingInstanceDirURI;
        private final URI newInstanceDirURI;

        private LocalHelper(File existingInstanceDir, File newInstanceDir) {
            this.existingInstanceDirURI = existingInstanceDir.toURI();
            this.newInstanceDirURI = newInstanceDir.toURI();
        }

        @Override
        protected void mkdirs(String dir) {
            File newDir = new File(this.newInstanceDirURI.resolve(dir));
            if (!newDir.exists() && !newDir.mkdirs()) {
                throw new RuntimeException(Strings.get("secure.admin.boot.errCreDir", newDir.getAbsolutePath()));
            }
        }

        @Override
        public void copyBootstrapFiles() throws IOException {
            for (String relativePathToFile : SECURE_ADMIN_FILE_REL_URIS_TO_COPY) {
                File origin = new File(this.existingInstanceDirURI.resolve(relativePathToFile));
                File dest = new File(this.newInstanceDirURI.resolve(relativePathToFile));
                FileUtils.copyFile((File)origin, (File)dest);
            }
        }

        @Override
        protected void backdateInstanceDomainXML() throws BootstrapException {
            File newDomainXMLFile = new File(this.newInstanceDirURI.resolve(SecureAdminBootstrapHelper.DOMAIN_XML_PATH));
            if (!newDomainXMLFile.setLastModified(0L)) {
                throw new RuntimeException(Strings.get("secure.admin.boot.errSetLastMod", newDomainXMLFile.getAbsolutePath()));
            }
        }

        @Override
        protected void close() {
        }
    }

    private static class DCOMHelper
    extends RemoteHelper {
        final WindowsRemoteFileSystem wrfs;
        final DcomInfo info;

        DCOMHelper(ServiceLocator habitat, File dasInstanceDir, String remoteNodeDir, String instance, Node node, Logger logger) throws BootstrapException {
            super(habitat, dasInstanceDir, remoteNodeDir, instance, node, logger);
            try {
                this.info = new DcomInfo(node);
                this.wrfs = new WindowsRemoteFileSystem(this.info.getHost(), this.info.getUser(), this.info.getPassword());
            }
            catch (WindowsException ex) {
                throw new BootstrapException((Exception)((Object)ex));
            }
        }

        @Override
        protected void close() {
        }

        @Override
        protected void mkdirs(String subdir) throws IOException {
            String remoteDir = this.remoteInstanceDir + subdir;
            this.logger.log(Level.FINE, "Trying to create directories for remote path {0}", remoteDir);
            try {
                WindowsRemoteFile f = new WindowsRemoteFile(this.wrfs, remoteDir);
                f.mkdirs();
                if (!f.exists()) {
                    throw new IOException(Strings.get("no.mkdir", f.getPath()));
                }
            }
            catch (WindowsException ex) {
                throw new IOException(ex.getMessage(), ex);
            }
        }

        @Override
        void writeToFile(String path, InputStream content) throws IOException {
            try {
                WindowsRemoteFile f = new WindowsRemoteFile(this.wrfs, path);
                f.copyFrom((BufferedInputStream)content);
            }
            catch (WindowsException ex) {
                throw new IOException(ex.getMessage(), ex);
            }
        }

        @Override
        void setLastModified(String path, long when) throws IOException {
            try {
                WindowsRemoteFile f = new WindowsRemoteFile(this.wrfs, path);
                f.setLastModified(when);
            }
            catch (WindowsException ex) {
                throw new IOException(ex.getMessage(), ex);
            }
        }

        @Override
        protected void backdateInstanceDomainXML() throws BootstrapException {
            String remoteDomainXML = this.remoteInstanceDir + SecureAdminBootstrapHelper.DOMAIN_XML_PATH;
            try {
                this.setLastModified(remoteDomainXML, 0L);
            }
            catch (IOException ex) {
                throw new BootstrapException(ex);
            }
            this.logger.log(Level.FINE, "Backdated the instance's copy of domain.xml");
        }
    }

    private static class SSHHelper
    extends RemoteHelper {
        final SFTPClient ftpClient;
        final SSHLauncher launcher;

        private SSHHelper(ServiceLocator habitat, File dasInstanceDir, String remoteNodeDir, String instance, Node node, Logger logger) throws BootstrapException {
            super(habitat, dasInstanceDir, remoteNodeDir, instance, node, logger);
            this.launcher = (SSHLauncher)habitat.getService(SSHLauncher.class, new Annotation[0]);
            this.launcher.init(node, logger);
            try {
                this.ftpClient = this.launcher.getSFTPClient();
            }
            catch (IOException ex) {
                throw new BootstrapException(this.launcher, ex);
            }
        }

        @Override
        protected void mkdirs(String dir) throws IOException {
            Integer instanceDirPermissions;
            String remoteDir = this.remoteInstanceDir + dir;
            this.logger.log(Level.FINE, "Trying to create directories for remote path {0}", remoteDir);
            try {
                instanceDirPermissions = this.ftpClient.lstat((String)this.remoteNodeDir).permissions;
            }
            catch (IOException ex) {
                throw new IOException(this.remoteNodeDir, ex);
            }
            this.logger.log(Level.FINE, "Creating remote bootstrap directory " + remoteDir + " with permissions " + instanceDirPermissions.toString());
            try {
                this.ftpClient.mkdirs(remoteDir, instanceDirPermissions.intValue());
            }
            catch (IOException ex) {
                throw new IOException(remoteDir, ex);
            }
        }

        @Override
        protected void close() {
            if (this.ftpClient != null) {
                this.ftpClient.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void writeToFile(String path, InputStream content) throws IOException {
            byte[] buffer = new byte[1024];
            try (BufferedOutputStream os = new BufferedOutputStream(this.ftpClient.writeToFile(path));){
                int bytesRead;
                while ((bytesRead = content.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, bytesRead);
                }
            }
        }

        @Override
        protected void backdateInstanceDomainXML() throws BootstrapException {
            String remoteDomainXML = this.remoteInstanceDir + SecureAdminBootstrapHelper.DOMAIN_XML_PATH;
            try {
                this.setLastModified(remoteDomainXML, 0L);
            }
            catch (IOException ex) {
                throw new BootstrapException(this.launcher, ex);
            }
            this.logger.log(Level.FINE, "Backdated the instance's copy of domain.xml");
        }

        @Override
        void setLastModified(String path, long when) throws IOException {
            SFTPv3FileAttributes attrs = this.ftpClient.stat(path);
            attrs.mtime = this.secondsSince_01_Jan_1970(when);
            this.ftpClient.setstat(path, attrs);
        }
    }

    private static abstract class RemoteHelper
    extends SecureAdminBootstrapHelper {
        final Logger logger;
        final File dasInstanceDir;
        final String instance;
        final String remoteNodeDir;
        final String remoteInstanceDir;

        RemoteHelper(ServiceLocator habitat, File dasInstanceDir, String remoteNodeDir, String instance, Node node, Logger logger) throws BootstrapException {
            this.dasInstanceDir = dasInstanceDir;
            this.instance = instance;
            this.logger = logger;
            this.remoteNodeDir = this.remoteNodeDirUnixStyle(node, remoteNodeDir);
            this.remoteInstanceDir = this.remoteInstanceDir(this.remoteNodeDir);
        }

        abstract void writeToFile(String var1, InputStream var2) throws IOException;

        abstract void setLastModified(String var1, long var2) throws IOException;

        String ensureTrailingSlash(String path) {
            if (!path.endsWith("/")) {
                return path + "/";
            }
            return path;
        }

        String remoteNodeDirUnixStyle(Node node, String remoteNodeDir) {
            String result = remoteNodeDir != null ? remoteNodeDir : this.ensureTrailingSlash(node.getInstallDirUnixStyle()) + "glassfish/nodes/" + node.getName();
            return this.ensureTrailingSlash(result.replaceAll("\\\\", "/"));
        }

        String remoteInstanceDir(String remoteNodeDirPath) {
            StringBuilder remoteInstancePath = new StringBuilder(remoteNodeDirPath);
            if (!remoteNodeDirPath.endsWith("/")) {
                remoteInstancePath.append("/");
            }
            remoteInstancePath.append(this.instance).append("/");
            return remoteInstancePath.toString().replaceAll("\\\\", "/");
        }

        @Override
        protected void copyBootstrapFiles() throws FileNotFoundException, IOException {
            for (String fileRelativePath : SECURE_ADMIN_FILE_REL_URIS_TO_COPY) {
                String remoteFilePath = null;
                try (InputStream is = null;){
                    is = new BufferedInputStream(new FileInputStream(new File(this.dasInstanceDir.toURI().resolve(fileRelativePath))));
                    remoteFilePath = this.remoteInstanceDir + fileRelativePath;
                    this.writeToFile(remoteFilePath, is);
                    this.logger.log(Level.FINE, "Copied bootstrap file to {0}", remoteFilePath);
                }
            }
        }

        Long secondsSince_01_Jan_1970(long milliseconds) {
            return milliseconds / 1000L;
        }
    }
}

