/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.v3.admin.cluster.DeleteNodeRemoteCommand;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="delete-node-ssh")
@I18n(value="delete.node.ssh")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Nodes.class, opType=RestEndpoint.OpType.DELETE, path="delete-node-ssh", description="Delete Node SSH")})
public class DeleteNodeSshCommand
extends DeleteNodeRemoteCommand {
    public final void execute(AdminCommandContext context) {
        this.executeInternal(context);
    }

    @Override
    protected final List<String> getPasswords() {
        ArrayList<String> list = new ArrayList<String>();
        NodeUtils nodeUtils = new NodeUtils(this.habitat, this.logger);
        list.add("AS_ADMIN_SSHPASSWORD=" + nodeUtils.sshL.expandPasswordAlias(this.remotepassword));
        if (this.sshkeypassphrase != null) {
            list.add("AS_ADMIN_SSHKEYPASSPHRASE=" + nodeUtils.sshL.expandPasswordAlias(this.sshkeypassphrase));
        }
        return list;
    }

    @Override
    protected String getUninstallCommandName() {
        return "uninstall-node-ssh";
    }

    @Override
    protected final void setTypeSpecificOperands(List<String> command, ParameterMap map) {
        command.add("--sshport");
        command.add((String)map.getOne((Object)"sshport"));
        command.add("--sshuser");
        command.add((String)map.getOne((Object)"sshuser"));
        String key = (String)map.getOne((Object)"sshkeyfile");
        if (key != null) {
            command.add("--sshkeyfile");
            command.add(key);
        }
    }
}

