/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.agent;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.instrument.Instrumentation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.appclient.client.AppClientFacade;
import org.glassfish.appclient.client.acc.UserError;

public class AppClientContainerAgent {
    private static Logger logger = Logger.getLogger(AppClientContainerAgent.class.getName());

    public static void premain(String agentArgsText, Instrumentation inst) {
        try {
            long now = System.currentTimeMillis();
            AppClientFacade.prepareACC((String)AppClientContainerAgent.optionsValue(agentArgsText), (Instrumentation)inst);
            logger.fine("AppClientContainerAgent finished after " + (System.currentTimeMillis() - now) + " ms");
        }
        catch (UserError ue) {
            ue.displayAndExit();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String optionsValue(String agentArgsText) throws FileNotFoundException, IOException {
        String result;
        if (agentArgsText == null) {
            throw new IllegalArgumentException();
        }
        if (!agentArgsText.startsWith("argsfile=")) {
            return agentArgsText;
        }
        File argsFile = new File(agentArgsText.substring("argsfile=".length()));
        LineNumberReader reader = new LineNumberReader(new FileReader(argsFile));
        try {
            result = reader.readLine();
        }
        finally {
            reader.close();
        }
        if (Boolean.getBoolean("keep.argsfile")) {
            System.err.println("Agent arguments file retained: " + argsFile.getAbsolutePath());
        } else if (!argsFile.delete()) {
            logger.log(Level.FINE, "Unable to delete temporary args file {0}; continuing", argsFile.getAbsolutePath());
        }
        return result;
    }
}

