/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ant.tasks;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.glassfish.ant.tasks.AdminTask;
import org.glassfish.ant.tasks.Component;

public class DeployTask
extends AdminTask {
    private String action;
    private String file;
    private Component component;
    private List<Component> components = new ArrayList<Component>();

    public DeployTask() {
        this.setAction("deploy");
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setName(String name) {
        this.addCommandParameter("name", name);
    }

    public void setContextroot(String contextroot) {
        this.addCommandParameter("contextroot", contextroot);
    }

    public void setPrecompilejsp(boolean precompilejsp) {
        this.addCommandParameter("precompilejsp", Boolean.toString(precompilejsp));
    }

    public void setVerify(boolean verify) {
        this.addCommandParameter("verify", Boolean.toString(verify));
    }

    public void setCreatetables(boolean createtables) {
        this.addCommandParameter("createtables", Boolean.toString(createtables));
    }

    public void setDropandcreatetables(boolean dropandcreatetables) {
        this.addCommandParameter("dropandcreatetables", Boolean.toString(dropandcreatetables));
    }

    public void setUniquetablenames(boolean uniquetablenames) {
        this.addCommandParameter("uniquetablenames", Boolean.toString(uniquetablenames));
    }

    public void setEnabled(boolean enabled) {
        this.addCommandParameter("enabled", Boolean.toString(enabled));
    }

    public void setAvailabilityenabled(boolean availabilityenabled) {
        this.addCommandParameter("availabilityenabled", Boolean.toString(availabilityenabled));
    }

    public void setVirtualservers(String virtualservers) {
        this.addCommandParameter("virtualservers", virtualservers);
    }

    public void setRetrievestubs(String retrieve) {
        this.addCommandParameter("retrieve", retrieve);
    }

    public void setdbvendorname(String dbvendorname) {
        this.addCommandParameter("dbvendorname", dbvendorname);
    }

    public void setLibraries(String libraries) {
        this.addCommandParameter("libraries", libraries);
    }

    public void setDeploymentPlan(String deploymentplan) {
        this.addCommandParameter("deploymentplan", deploymentplan);
    }

    public void setForce(boolean force) {
        this.addCommandParameter("force", Boolean.toString(force));
    }

    public void setUpload(boolean force) {
        this.addCommandParameter("upload", Boolean.toString(force));
    }

    public void setProperties(String properties) {
        this.addCommandParameter("properties", properties);
    }

    public void setType(String type) {
        this.addCommandParameter("type", type);
    }

    public Component createComponent() {
        this.component = new Component();
        this.components.add(this.component);
        return this.component;
    }

    @Override
    public void execute() throws BuildException {
        if (this.components.size() == 0 && this.file == null) {
            this.log("File attributes or component must be specified", 1);
            return;
        }
        if (this.components != null) {
            this.processComponents();
        }
        if (this.file != null) {
            this.addCommandOperand(this.file);
            super.execute(this.action + " " + this.getCommand());
        }
    }

    private void processComponents() throws BuildException {
        for (Component comp : this.components) {
            if (comp.name != null) {
                comp.addCommandParameter("name", comp.name);
            }
            if (comp.file == null) {
                this.log("File attribute must be specified in component to deploy", 1);
                continue;
            }
            comp.addCommandOperand(comp.file);
            super.execute(this.action + " " + comp.getCommand());
        }
    }
}

