/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.plugin.jms;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.connectors.jms.system.JmsProviderLifecycle;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.plugin.jms.JMXUtil;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.JMSDestination;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;
import org.glassfish.resources.api.PoolInfo;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsHandlers {
    protected static final String OBJECT_DEST_MGR = "com.sun.messaging.jms.server:type=DestinationManager,subtype=Config";
    protected static final String OBJECT_DEST_BASE = "com.sun.messaging.jms.server:type=Destination";
    protected static final String SUBTYPE_CONFIG = "Config";
    protected static final String SUBTYPE_MONITOR = "Monitor";
    protected static final String OP_LIST_DESTINATIONS = "getDestinations";
    protected static final String OP_CREATE = "create";
    protected static final String OP_DESTROY = "destroy";
    protected static final String OP_PURGE = "purge";
    protected static final String ATTR_CONSUMER_FLOW_LIMIT = "ConsumerFlowLimit";
    protected static final String ATTR_LIMIT_BEHAVIOR = "LimitBehavior";
    protected static final String ATTR_LOCAL_DELIVERY_PREFERRED = "LocalDeliveryPreferred";
    protected static final String ATTR_MAX_BYTES_PER_MSG = "MaxBytesPerMsg";
    protected static final String ATTR_MAX_NUM_ACTIVE_CONSUMERS = "MaxNumActiveConsumers";
    protected static final String ATTR_MAX_NUM_BACKUP_CONSUMERS = "MaxNumBackupConsumers";
    protected static final String ATTR_MAX_NUM_PRODUCERS = "MaxNumProducers";
    protected static final String ATTR_USE_DMQ = "UseDMQ";
    protected static final String ATTR_MAX_NUM_MSGS = "MaxNumMsgs";
    protected static final String ATTR_MAX_TOTAL_MSG_BYTES = "MaxTotalMsgBytes";
    protected static final String ATTR_VALIDATE_XML_SCHEMA_ENABLED = "ValidateXMLSchemaEnabled";
    protected static final String ATTR_XML_SCHEMA_URI_LIST = "XMLSchemaURIList";
    protected static final String ATTR_CREATED_BY_ADMIN = "CreatedByAdmin";
    protected static final String ATTR_TEMPORARY = "Temporary";
    protected static final String ATTR_CONNECTION_ID = "ConnectionID";
    protected static final String ATTR_STATE = "State";
    protected static final String ATTR_STATE_LABEL = "StateLabel";
    protected static final String ATTR_NUM_PRODUCERS = "NumProducers";
    protected static final String ATTR_NUM_CONSUMERS = "NumConsumers";
    protected static final String ATTR_NUM_WILDCARD_PRODUCERS = "NumWildcardProducers";
    protected static final String ATTR_NUM_WILDCARD_CONSUMERS = "NumWildcardConsumers";
    protected static final String ATTR_NUM_WILDCARDS = "NumWildcards";
    protected static final String ATTR_PEAK_NUM_CONSUMERS = "PeakNumConsumers";
    protected static final String ATTR_AVG_NUM_CONSUMERS = "AvgNumConsumers";
    protected static final String ATTR_NUM_ACTIVE_CONSUMERS = "NumActiveConsumers";
    protected static final String ATTR_PEAK_NUM_ACTIVE_CONSUMERS = "PeakNumActiveConsumers";
    protected static final String ATTR_AVG_NUM_ACTIVE_CONSUMERS = "AvgNumActiveConsumers";
    protected static final String ATTR_NUM_BACKUP_CONSUMERS = "NumBackupConsumers";
    protected static final String ATTR_PEAK_NUM_BACKUP_CONSUMERS = "PeakNumBackupConsumers";
    protected static final String ATTR_AVG_NUM_BACKUP_CONSUMERS = "AvgNumBackupConsumers";
    protected static final String ATTR_NUM_MSGS = "NumMsgs";
    protected static final String ATTR_NUM_MSGS_REMOTE = "NumMsgsRemote";
    protected static final String ATTR_NUM_MSGS_PENDING_ACKS = "NumMsgsPendingAcks";
    protected static final String ATTR_NUM_MSGS_HELD_IN_TRANSACTION = "NumMsgsHeldInTransaction";
    protected static final String ATTR_NEXT_MESSAGE_ID = "NextMessageID";
    protected static final String ATTR_PEAK_NUM_MSGS = "PeakNumMsgs";
    protected static final String ATTR_AVG_NUM_MSGS = "AvgNumMsgs";
    protected static final String ATTR_NUM_MSGS_IN = "NumMsgsIn";
    protected static final String ATTR_NUM_MSGS_OUT = "NumMsgsOut";
    protected static final String ATTR_MSG_BYTES_IN = "MsgBytesIn";
    protected static final String ATTR_MSG_BYTES_OUT = "MsgBytesOut";
    protected static final String ATTR_PEAK_MSG_BYTES = "PeakMsgBytes";
    protected static final String ATTR_TOTAL_MSG_BYTES = "TotalMsgBytes";
    protected static final String ATTR_TOTAL_MSG_BYTES_REMOTE = "TotalMsgBytesRemote";
    protected static final String ATTR_TOTAL_MSG_BYTES_HELD_IN_TRANSACTION = "TotalMsgBytesHeldInTransaction";
    protected static final String ATTR_PEAK_TOTAL_MSG_BYTES = "PeakTotalMsgBytes";
    protected static final String ATTR_AVG_TOTAL_MSG_BYTES = "AvgTotalMsgBytes";
    protected static final String ATTR_DISK_RESERVED = "DiskReserved";
    protected static final String ATTR_DISK_USED = "DiskUsed";
    protected static final String ATTR_DISK_UTILIZATION_RATIO = "DiskUtilizationRatio";
    private static final String[] ATTRS_CONFIG = new String[]{"MaxNumMsgs", "MaxBytesPerMsg", "MaxTotalMsgBytes", "LimitBehavior", "MaxNumProducers", "MaxNumActiveConsumers", "MaxNumBackupConsumers", "ConsumerFlowLimit", "LocalDeliveryPreferred", "UseDMQ", "ValidateXMLSchemaEnabled", "XMLSchemaURIList"};
    private static final String[] ATTRS_MONITOR = new String[]{"CreatedByAdmin", "Temporary", "ConnectionID", "State", "StateLabel", "NumProducers", "NumConsumers", "NumWildcardProducers", "NumWildcardConsumers", "NumWildcards", "PeakNumConsumers", "AvgNumConsumers", "NumActiveConsumers", "PeakNumActiveConsumers", "AvgNumActiveConsumers", "NumBackupConsumers", "PeakNumBackupConsumers", "AvgNumBackupConsumers", "NumMsgs", "NumMsgsRemote", "NumMsgsPendingAcks", "NumMsgsHeldInTransaction", "NextMessageID", "PeakNumMsgs", "AvgNumMsgs", "NumMsgsIn", "NumMsgsOut", "MsgBytesIn", "MsgBytesOut", "PeakMsgBytes", "TotalMsgBytes", "TotalMsgBytesRemote", "TotalMsgBytesHeldInTransaction", "PeakTotalMsgBytes", "AvgTotalMsgBytes", "DiskReserved", "DiskUsed", "DiskUtilizationRatio"};
    protected static final String PROP_NAME = "name";
    protected static final String PROP_DEST_TYPE = "desttype";

    public static void getPhysicalDestination(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue(PROP_NAME);
        String type = (String)handlerCtx.getInputValue("type");
        HashMap<String, String> valueMap = new HashMap<String, String>();
        try {
            String objectName = JmsHandlers.getJmsDestinationObjectName(SUBTYPE_CONFIG, name, type);
            AttributeList attributes = JMXUtil.getMBeanServer().getAttributes(new ObjectName(objectName), ATTRS_CONFIG);
            for (Attribute attribute : attributes.asList()) {
                valueMap.put(attribute.getName(), attribute.getValue() != null ? attribute.getValue().toString() : null);
            }
            handlerCtx.setOutputValue("destData", valueMap);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
        handlerCtx.setOutputValue("destData", valueMap);
    }

    public static void getPhysicalDestinationStats(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue(PROP_NAME);
        String type = (String)handlerCtx.getInputValue("type");
        String target = (String)handlerCtx.getInputValue("target");
        ArrayList<Map> statsList = new ArrayList<Map>();
        try {
            JmsHandlers.insureJmsBrokerIsRunning();
            String objectName = JmsHandlers.getJmsDestinationObjectName(SUBTYPE_MONITOR, name, type);
            AttributeList attributes = JmsHandlers.getMBeanServerConnection(target).getAttributes(new ObjectName(objectName), ATTRS_MONITOR);
            ResourceBundle bundle = GuiUtil.getBundle((String)"org.glassfish.jms.admingui.Strings");
            statsList.add(JmsHandlers.createRow("Name", name, ""));
            statsList.add(JmsHandlers.createRow("Type", type.substring(0, 1).toUpperCase(GuiUtil.guiLocale) + type.substring(1), ""));
            for (Attribute attribute : attributes.asList()) {
                statsList.add(JmsHandlers.createRow(GuiUtil.getMessage((ResourceBundle)bundle, (String)("jmsPhysDestinations." + attribute.getName())), attribute.getValue(), GuiUtil.getMessage((ResourceBundle)bundle, (String)("jmsPhysDestinations." + attribute.getName() + "Help"))));
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
        handlerCtx.setOutputValue("statsData", statsList);
    }

    public static void getPhysicalDestinations(HandlerContext handlerCtx) {
        ObjectName[] objectNames = null;
        ArrayList result = new ArrayList();
        try {
            JmsHandlers.insureJmsBrokerIsRunning();
            objectNames = (ObjectName[])JMXUtil.invoke(OBJECT_DEST_MGR, OP_LIST_DESTINATIONS);
            if (objectNames == null) {
                handlerCtx.setOutputValue("result", result);
                return;
            }
            List selectedList = (List)handlerCtx.getInputValue("selectedRows");
            boolean hasOrig = selectedList != null && selectedList.size() != 0;
            for (int i = 0; i < objectNames.length; ++i) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put(PROP_NAME, objectNames[i].getKeyProperty(PROP_NAME).replaceAll("\"", ""));
                oneRow.put("type", "t".equals(objectNames[i].getKeyProperty(PROP_DEST_TYPE)) ? "topic" : "queue");
                oneRow.put("selected", hasOrig ? JmsHandlers.isSelected(objectNames[i].getKeyProperty(PROP_NAME), selectedList) : false);
                result.add(oneRow);
            }
        }
        catch (Exception ex) {
            System.out.println("invoke:   com.sun.messaging.jms.server:type=DestinationManager,subtype=Config, method  =  getDestinations");
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void createPhysicalDestination(HandlerContext handlerCtx) {
        try {
            String type = (String)handlerCtx.getInputValue("type");
            String name = (String)handlerCtx.getInputValue(PROP_NAME);
            AttributeList list = new AttributeList();
            Map attrMap = (Map)handlerCtx.getInputValue("attributes");
            JmsHandlers.buildAttributeList(list, attrMap, type);
            String[] types = new String[]{"java.lang.String", "java.lang.String", "javax.management.AttributeList"};
            Object[] params = new Object[]{type, name, list};
            JMXUtil.invoke(OBJECT_DEST_MGR, OP_CREATE, params, types);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void updatePhysicalDestination(HandlerContext handlerCtx) {
        try {
            String type = (String)handlerCtx.getInputValue("type");
            String name = (String)handlerCtx.getInputValue(PROP_NAME);
            AttributeList list = new AttributeList();
            Map attrMap = (Map)handlerCtx.getInputValue("attributes");
            JmsHandlers.buildAttributeList(list, attrMap, type);
            String objectName = JmsHandlers.getJmsDestinationObjectName(SUBTYPE_CONFIG, name, type);
            JMXUtil.getMBeanServer().setAttributes(new ObjectName(objectName), list);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void deleteJMSDest(HandlerContext handlerCtx) {
        List obj;
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get(PROP_NAME);
                String type = ((String)oneRow.get("type")).substring(0, 1).toLowerCase(GuiUtil.guiLocale);
                Object[] params = new Object[]{type, name};
                String[] types = new String[]{"java.lang.String", "java.lang.String"};
                JMXUtil.invoke(OBJECT_DEST_MGR, OP_DESTROY, params, types);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void flushJMSDestination(HandlerContext handlerCtx) {
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get(PROP_NAME);
                String type = (String)oneRow.get("type");
                JMXUtil.invoke(JmsHandlers.getJmsDestinationObjectName(SUBTYPE_CONFIG, name, type), OP_PURGE);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getDefaultPhysicalDestinationValues(HandlerContext handlerCtx) {
        Map orig = (Map)handlerCtx.getInputValue("orig");
        Map<String, String> map = new HashMap<String, String>();
        if (orig != null) {
            map = orig;
        }
        map.put(ATTR_MAX_NUM_MSGS, "-1");
        map.put(ATTR_MAX_BYTES_PER_MSG, "-1");
        map.put(ATTR_MAX_TOTAL_MSG_BYTES, "-1");
        map.put(ATTR_LIMIT_BEHAVIOR, "REJECT_NEWEST");
        map.put(ATTR_MAX_NUM_PRODUCERS, "100");
        map.put(ATTR_MAX_NUM_ACTIVE_CONSUMERS, "-1");
        map.put(ATTR_MAX_NUM_BACKUP_CONSUMERS, "0");
        map.put(ATTR_CONSUMER_FLOW_LIMIT, "1000");
        map.put(ATTR_LOCAL_DELIVERY_PREFERRED, "false");
        map.put(ATTR_USE_DMQ, "true");
        map.put(ATTR_VALIDATE_XML_SCHEMA_ENABLED, "false");
        map.put(ATTR_XML_SCHEMA_URI_LIST, "");
        handlerCtx.setOutputValue("map", map);
    }

    public static void pingJms(HandlerContext handlerCtx) {
        try {
            String poolName = (String)handlerCtx.getInputValue("poolName");
            com.sun.enterprise.connectors.ConnectorRuntime connectorRuntime = (com.sun.enterprise.connectors.ConnectorRuntime)GuiUtil.getHabitat().getComponent(com.sun.enterprise.connectors.ConnectorRuntime.class);
            PoolInfo poolInfo = new PoolInfo(poolName);
            connectorRuntime.pingConnectionPool(poolInfo);
            GuiUtil.prepareAlert((String)"success", (String)GuiUtil.getMessage((String)"msg.PingSucceed"), null);
        }
        catch (Exception ex) {
            GuiUtil.prepareAlert((String)"error", (String)GuiUtil.getMessage((String)"msg.Error"), (String)ex.getMessage());
        }
    }

    public static void getDestinations(HandlerContext handlerCtx) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.invoke(new ObjectName(OBJECT_DEST_MGR), OP_LIST_DESTINATIONS, new Object[0], new String[0]);
        }
        catch (Exception ex) {
            Logger.getLogger(JmsHandlers.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static boolean isSelected(String name, List<Map> selectedList) {
        if (selectedList == null || name == null) {
            return false;
        }
        for (Map oneRow : selectedList) {
            if (!name.equals(oneRow.get(PROP_NAME))) continue;
            return true;
        }
        return false;
    }

    protected static String getJmsDestinationObjectName(String objectType, String name, String destType) {
        return "com.sun.messaging.jms.server:type=Destination,subtype=" + objectType + ",desttype=" + destType.substring(0, 1).toLowerCase(GuiUtil.guiLocale) + ",name=\"" + name + "\"";
    }

    protected static void buildAttributeList(AttributeList list, Map attrMap, String type) {
        list.add(new Attribute(ATTR_MAX_NUM_MSGS, Long.parseLong((String)attrMap.get(ATTR_MAX_NUM_MSGS))));
        list.add(new Attribute(ATTR_MAX_BYTES_PER_MSG, Long.parseLong((String)attrMap.get(ATTR_MAX_BYTES_PER_MSG))));
        list.add(new Attribute(ATTR_MAX_TOTAL_MSG_BYTES, Long.parseLong((String)attrMap.get(ATTR_MAX_TOTAL_MSG_BYTES))));
        list.add(new Attribute(ATTR_LIMIT_BEHAVIOR, (String)attrMap.get(ATTR_LIMIT_BEHAVIOR)));
        list.add(new Attribute(ATTR_MAX_NUM_PRODUCERS, Integer.parseInt((String)attrMap.get(ATTR_MAX_NUM_PRODUCERS))));
        if ("queue".equals(type)) {
            list.add(new Attribute(ATTR_MAX_NUM_ACTIVE_CONSUMERS, Integer.parseInt((String)attrMap.get(ATTR_MAX_NUM_ACTIVE_CONSUMERS))));
            list.add(new Attribute(ATTR_MAX_NUM_BACKUP_CONSUMERS, Integer.parseInt((String)attrMap.get(ATTR_MAX_NUM_BACKUP_CONSUMERS))));
            list.add(new Attribute(ATTR_LOCAL_DELIVERY_PREFERRED, Boolean.valueOf((String)attrMap.get(ATTR_LOCAL_DELIVERY_PREFERRED))));
        }
        list.add(new Attribute(ATTR_CONSUMER_FLOW_LIMIT, Long.parseLong((String)attrMap.get(ATTR_CONSUMER_FLOW_LIMIT))));
        list.add(new Attribute(ATTR_USE_DMQ, Boolean.valueOf((String)attrMap.get(ATTR_USE_DMQ))));
        list.add(new Attribute(ATTR_VALIDATE_XML_SCHEMA_ENABLED, Boolean.valueOf((String)attrMap.get(ATTR_VALIDATE_XML_SCHEMA_ENABLED))));
        list.add(new Attribute(ATTR_XML_SCHEMA_URI_LIST, (String)attrMap.get(ATTR_XML_SCHEMA_URI_LIST)));
    }

    protected static void insureJmsBrokerIsRunning() throws ConnectorRuntimeException {
        JmsProviderLifecycle jpl = (JmsProviderLifecycle)GuiUtil.getHabitat().getComponent(JmsProviderLifecycle.class);
        jpl.initializeBroker();
    }

    private static Map createRow(String label, Object value, String helpText) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("label", label);
        map.put("value", value != null ? value.toString() : null);
        map.put("help", helpText);
        return map;
    }

    private static MBeanServerConnection getMBeanServerConnection(String target) throws ConnectorRuntimeException, Exception {
        Habitat habitat = GuiUtil.getHabitat();
        Domain domain = (Domain)habitat.getComponent(Domain.class);
        Cluster cluster = domain.getClusterNamed(target);
        String configRef = null;
        if (cluster == null) {
            Server server = domain.getServerNamed(target);
            configRef = server.getConfigRef();
        } else {
            configRef = cluster.getConfigRef();
        }
        PhysicalDestinations pd = new PhysicalDestinations();
        MQJMXConnectorInfo mqInfo = pd.getConnectorInfo(target, configRef, habitat, domain);
        return mqInfo.getMQMBeanServerConnection();
    }

    private static class PhysicalDestinations
    extends JMSDestination {
        private PhysicalDestinations() {
        }

        public MQJMXConnectorInfo getConnectorInfo(String target, String configName, Habitat habitat, Domain domain) throws Exception {
            return this.getMQJMXConnectorInfo(target, domain.getConfigNamed(configName), (ServerContext)habitat.getComponent(ServerContext.class), domain, (ConnectorRuntime)habitat.getComponent(com.sun.enterprise.connectors.ConnectorRuntime.class));
        }
    }
}

