/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.remote.RemoteRestAdminCommand;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.net.NetUtils;
import java.io.Console;
import java.io.IOException;
import java.net.ConnectException;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.FileRealmHelper;
import org.jvnet.hk2.annotations.Service;

@Service(name="change-admin-password")
@PerLookup
@I18n(value="change.admin.password")
public class ChangeAdminPasswordCommand
extends LocalDomainCommand {
    private ParameterMap params;
    private static final LocalStringsImpl strings = new LocalStringsImpl(ChangeAdminPasswordCommand.class);
    @Param(name="domain_name", optional=true)
    private String userArgDomainName;
    @Param(password=true, optional=true)
    private String password;
    @Param(password=true, optional=true)
    private String newpassword;
    private SecureAdmin secureAdmin = null;

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.userArgDomainName);
        super.validate();
        if (this.programOpts.getUser() == null) {
            Console cons = System.console();
            if (cons != null && this.programOpts.isInteractive()) {
                cons.printf("%s", strings.get("AdminUserDefaultPrompt", new Object[]{"admin"}));
                String val = cons.readLine();
                if (ChangeAdminPasswordCommand.ok((String)val)) {
                    this.programOpts.setUser(val);
                } else {
                    this.programOpts.setUser("admin");
                }
            } else {
                throw new CommandValidationException(strings.get("AdminUserRequired"));
            }
        }
        if (this.password == null) {
            this.password = this.getPassword("password", strings.get("AdminPassword"), null, false);
            if (this.password == null) {
                throw new CommandValidationException(strings.get("AdminPwRequired"));
            }
            this.programOpts.setPassword(this.password, ProgramOptions.PasswordLocation.USER);
        }
        if (this.newpassword == null) {
            this.newpassword = this.getPassword("newpassword", strings.get("change.admin.password.newpassword"), strings.get("change.admin.password.newpassword.again"), true);
            if (this.newpassword == null) {
                throw new CommandValidationException(strings.get("AdminNewPwRequired"));
            }
        }
        this.params = new ParameterMap();
        this.params.set((Object)"DEFAULT", (Object)this.programOpts.getUser());
        this.params.set((Object)"password", (Object)this.password);
        this.params.set((Object)"newpassword", (Object)this.newpassword);
    }

    protected int executeCommand() throws CommandException {
        if (ChangeAdminPasswordCommand.ok((String)this.domainDirParam) || ChangeAdminPasswordCommand.ok((String)this.userArgDomainName)) {
            String domainDir = ChangeAdminPasswordCommand.ok((String)this.domainDirParam) ? this.domainDirParam : this.getDomainsDir().getPath();
            String domainName = ChangeAdminPasswordCommand.ok((String)this.userArgDomainName) ? this.userArgDomainName : this.getDomainName();
            return this.changeAdminPasswordLocally(domainDir, domainName);
        }
        try {
            RemoteRestAdminCommand rac = new RemoteRestAdminCommand(this.name, this.programOpts.getHost(), this.programOpts.getPort(), this.programOpts.isSecure(), this.programOpts.getUser(), this.programOpts.getPassword(), logger);
            rac.executeCommand(this.params);
            return 0;
        }
        catch (CommandException ce) {
            if (ce.getCause() instanceof ConnectException) {
                if (!ChangeAdminPasswordCommand.isLocalHost(this.programOpts.getHost())) {
                    throw ce;
                }
                return this.changeAdminPasswordLocally(this.getDomainsDir().getPath(), this.getDomainName());
            }
            throw ce;
        }
    }

    private int changeAdminPasswordLocally(String domainDir, String domainName) throws CommandException {
        if (!ChangeAdminPasswordCommand.isLocalHost(this.programOpts.getHost())) {
            throw new CommandException(strings.get("CannotExecuteLocally"));
        }
        GFLauncher launcher = null;
        try {
            launcher = GFLauncherFactory.getInstance((RuntimeType)RuntimeType.DAS);
            GFLauncherInfo info = launcher.getInfo();
            info.setDomainName(domainName);
            info.setDomainParentDir(domainDir);
            launcher.setup();
            if (launcher.isSecureAdminEnabled() && (this.newpassword == null || this.newpassword.isEmpty())) {
                throw new CommandException(strings.get("NullNewPassword"));
            }
            String adminKeyFile = launcher.getAdminRealmKeyFile();
            if (adminKeyFile != null) {
                FileRealmHelper helper = new FileRealmHelper(adminKeyFile);
                String[] groups = helper.authenticate(this.programOpts.getUser(), this.password.toCharArray());
                if (groups == null) {
                    throw new CommandException(strings.get("InvalidCredentials", new Object[]{this.programOpts.getUser()}));
                }
                helper.updateUser(this.programOpts.getUser(), this.programOpts.getUser(), this.newpassword.toCharArray(), null);
                helper.persist();
                return 0;
            }
            throw new CommandException(strings.get("NotFileRealmCannotChangeLocally"));
        }
        catch (MiniXmlParserException ex) {
            throw new CommandException((Throwable)ex);
        }
        catch (GFLauncherException ex) {
            throw new CommandException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new CommandException((Throwable)ex);
        }
    }

    private static boolean isLocalHost(String host) {
        return host != null && (NetUtils.isThisHostLocal((String)host) || NetUtils.isLocal((String)host));
    }
}

