/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.stringsubs.Substitutable;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.FileLister;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.FileSubstitutionHandler;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.LargeFileSubstitutionHandler;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.SmallFileSubstitutionHandler;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.SubstitutionFileUtil;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.FileEntry;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FileEntryFactory {
    private static final Logger _logger = Logger.getLogger(FileEntryFactory.class.getPackage().getName());
    private static final LocalStringsImpl _strings = new LocalStringsImpl(FileEntryFactory.class);

    FileEntryFactory() {
    }

    List<Substitutable> getFileElements(FileEntry fileEntry) {
        String[] pathEntries = fileEntry.getName().split(",");
        ArrayList<LargeFileSubstitutionHandler> substituables = null;
        List<File> retrievedFiles = null;
        for (String pathEntry : pathEntries) {
            String isRegex = fileEntry.getRegex();
            if (Boolean.getBoolean(isRegex) || "yes".equalsIgnoreCase(isRegex)) {
                File file = new File(pathEntry);
                File parentDir = file.getParentFile();
                if (parentDir == null || !parentDir.exists()) continue;
                retrievedFiles = new ArrayList<File>();
                String expression = file.getName();
                String[] fileList = parentDir.list();
                Pattern pattern = Pattern.compile(expression);
                for (String fileName : fileList) {
                    Matcher matcher = pattern.matcher(fileName);
                    if (!matcher.matches()) continue;
                    File matchingFile = new File(parentDir, fileName);
                    if (matchingFile.exists() && matchingFile.canRead() && matchingFile.canWrite()) {
                        retrievedFiles.add(matchingFile);
                        continue;
                    }
                    _logger.log(Level.FINER, _strings.get("skipFileFromSubstitution", new Object[]{matchingFile.getAbsolutePath()}));
                }
            } else {
                FileLister fileLocator = new FileLister();
                retrievedFiles = fileLocator.getFiles(fileEntry.getName());
            }
            if (retrievedFiles == null || retrievedFiles.isEmpty()) {
                _logger.log(Level.FINER, _strings.get("noMatchedFile", new Object[]{pathEntry}));
                continue;
            }
            if (substituables == null) {
                substituables = new ArrayList<LargeFileSubstitutionHandler>(retrievedFiles.size());
            }
            for (File retrievedFile : retrievedFiles) {
                if (!retrievedFile.exists()) continue;
                try {
                    FileSubstitutionHandler substituable = retrievedFile.length() > (long)SubstitutionFileUtil.getInMemorySubstitutionFileSizeInBytes() ? new LargeFileSubstitutionHandler(retrievedFile) : new SmallFileSubstitutionHandler(retrievedFile);
                    substituables.add((LargeFileSubstitutionHandler)substituable);
                }
                catch (FileNotFoundException e) {
                    _logger.log(Level.WARNING, _strings.get("invalidFileLocation", new Object[]{retrievedFile}), e);
                }
            }
        }
        return substituables == null ? Collections.EMPTY_LIST : substituables;
    }
}

