/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.domain.DomainInfoManager;
import com.sun.enterprise.admin.servermgmt.domain.DomainPortValidator;
import com.sun.enterprise.admin.servermgmt.domain.DomainSecurity;
import com.sun.enterprise.admin.servermgmt.domain.DomainTemplate;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainConfigValidator;
import com.sun.enterprise.admin.servermgmt.pe.SubstitutableTokens;
import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutionFactory;
import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutor;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.AttributePreprocessorImpl;
import com.sun.enterprise.admin.servermgmt.template.TemplateInfoHolder;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.Property;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.PropertyType;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DomainBuilder {
    private static final Logger _logger = Logger.getLogger(DomainPortValidator.class.getPackage().getName());
    private static final LocalStringsImpl _strings = new LocalStringsImpl(DomainBuilder.class);
    private static final String STRINGSUBS_FILE = "stringsubs.xml";
    private static final String TEMPLATE_INFO_XML = "template-info.xml";
    private DomainConfig _domainConfig;
    private JarFile _templateJar;
    private DomainTemplate _domainTempalte;
    private Properties _defaultPortValues = new Properties();
    private byte[] keystoreBytes = null;
    private Set<String> extractedEntries = new HashSet<String>();

    public DomainBuilder(DomainConfig domainConfig) throws DomainException {
        this._domainConfig = domainConfig;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws DomainException {
        block12: {
            String templateJarPath = (String)this._domainConfig.get("template.name");
            try {
                this._templateJar = new JarFile(new File(templateJarPath));
                JarEntry je = this._templateJar.getJarEntry("config/domain.xml");
                if (je == null) {
                    throw new DomainException(_strings.get("missingMandatoryFile", new Object[]{"domain.xml"}));
                }
                je = this._templateJar.getJarEntry(TEMPLATE_INFO_XML);
                if (je == null) {
                    throw new DomainException(_strings.get("missingMandatoryFile", new Object[]{TEMPLATE_INFO_XML}));
                }
                TemplateInfoHolder templateInfoHolder = new TemplateInfoHolder(this._templateJar.getInputStream(je), templateJarPath);
                this.extractedEntries.add(TEMPLATE_INFO_XML);
                je = this._templateJar.getJarEntry(STRINGSUBS_FILE);
                StringSubstitutor stringSubstitutor = null;
                if (je != null) {
                    stringSubstitutor = StringSubstitutionFactory.createStringSubstitutor(this._templateJar.getInputStream(je));
                    List<Property> defaultStringSubsProps = stringSubstitutor.getDefaultProperties(PropertyType.PORT);
                    for (Property prop : defaultStringSubsProps) {
                        this._defaultPortValues.setProperty(prop.getKey(), prop.getValue());
                    }
                    this.extractedEntries.add(je.getName());
                } else {
                    _logger.log(Level.WARNING, _strings.get("missingFile", new Object[]{STRINGSUBS_FILE}));
                }
                this._domainTempalte = new DomainTemplate(templateInfoHolder, stringSubstitutor);
                je = this._templateJar.getJarEntry("config/keystore.jks");
                if (je == null) break block12;
                this.keystoreBytes = new byte[(int)je.getSize()];
                InputStream in = null;
                int count = 0;
                try {
                    in = this._templateJar.getInputStream(je);
                    count = in.read(this.keystoreBytes);
                    if (count < this.keystoreBytes.length) {
                        throw new DomainException(_strings.get("loadingFailure", new Object[]{je.getName()}));
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                this.extractedEntries.add(je.getName());
            }
            catch (Exception e) {
                throw new DomainException(e);
            }
        }
    }

    public void validateTemplate() throws DomainException {
        try {
            RepositoryManager repoManager = new RepositoryManager();
            repoManager.checkRepository(this._domainConfig, false);
            DomainPortValidator portValidator = new DomainPortValidator(this._domainConfig, this._defaultPortValues);
            portValidator.validateAndSetPorts();
            new PEDomainConfigValidator().validate(this._domainConfig);
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws RepositoryException, DomainException {
        File domainDir = FileUtils.safeGetCanonicalFile((File)new File(this._domainConfig.getRepositoryRoot(), this._domainConfig.getDomainName()));
        try {
            if (!domainDir.mkdirs()) {
                throw new RepositoryException(_strings.get("directoryCreationError", new Object[]{domainDir}));
            }
        }
        catch (Exception e) {
            throw new RepositoryException(_strings.get("directoryCreationError", new Object[]{domainDir}), e);
        }
        try {
            byte[] buffer = new byte[10000];
            Enumeration<JarEntry> entry = this._templateJar.entries();
            while (entry.hasMoreElements()) {
                JarEntry jarEntry = entry.nextElement();
                String entryName = jarEntry.getName();
                if (this.extractedEntries.contains(entryName)) continue;
                if (jarEntry.isDirectory()) {
                    File dir = new File(domainDir, jarEntry.getName());
                    if (dir.exists() || dir.mkdir()) continue;
                    _logger.log(Level.WARNING, _strings.get("directoryCreationError", new Object[]{dir.getName()}));
                    continue;
                }
                InputStream in = null;
                FilterOutputStream outputStream = null;
                try {
                    in = this._templateJar.getInputStream(jarEntry);
                    outputStream = new BufferedOutputStream(new FileOutputStream(new File(domainDir.getAbsolutePath(), jarEntry.getName())));
                    int i = 0;
                    while ((i = in.read(buffer)) != -1) {
                        ((BufferedOutputStream)outputStream).write(buffer, 0, i);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception io) {}
                    }
                    if (outputStream == null) continue;
                    try {
                        outputStream.close();
                    }
                    catch (Exception io) {}
                }
            }
            File configDir = new File(domainDir, "config");
            String user = (String)this._domainConfig.get("domain.user");
            String password = (String)this._domainConfig.get("domain.password");
            String masterPassword = (String)this._domainConfig.get("domain.masterPassword");
            Boolean saveMasterPassword = (Boolean)this._domainConfig.get("domain.saveMasterPassword");
            DomainSecurity domainSecurity = new DomainSecurity();
            domainSecurity.processAdminKeyFile(new File(configDir, "admin-keyfile"), user, password);
            try {
                domainSecurity.createSSLCertificateDatabase(configDir, this._domainConfig, masterPassword);
            }
            catch (Exception e) {
                String msg = _strings.getString("SomeProblemWithKeytool", e.getMessage());
                System.err.println(msg);
                FileOutputStream fos = null;
                try {
                    File keystoreFile = new File(configDir, "keystore.jks");
                    fos = new FileOutputStream(keystoreFile);
                    fos.write(this.keystoreBytes);
                }
                catch (Exception ex) {
                    SLogger.getLogger().log(Level.SEVERE, "SERVERMGMT0000", ex);
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            domainSecurity.changeMasterPasswordInMasterPasswordFile(new File(configDir, "master-password"), masterPassword, (boolean)saveMasterPassword);
            domainSecurity.createPasswordAliasKeystore(new File(configDir, "domain-passwords"), masterPassword);
            if (this._domainTempalte.hasStringsubs()) {
                StringSubstitutor substitutor = this._domainTempalte.getStringSubs();
                Map<String, String> lookUpMap = SubstitutableTokens.getSubstitutableTokens(this._domainConfig);
                substitutor.setLookUpMap(lookUpMap);
                substitutor.setAttributePreprocessor(new AttributePreprocessorImpl(lookUpMap));
                substitutor.substituteAll();
            }
            try {
                domainSecurity.changeMode("-R u+x ", new File(domainDir, "bin"));
                domainSecurity.changeMode("-R g-rwx,o-rwx ", configDir);
            }
            catch (Exception e) {
                throw new DomainException(_strings.get("setPermissionError"), e);
            }
            DomainInfoManager domainInfoManager = new DomainInfoManager();
            domainInfoManager.process(this._domainTempalte, domainDir);
        }
        catch (DomainException de) {
            FileUtils.liquidate((File)domainDir);
            throw de;
        }
        catch (Exception ex) {
            FileUtils.liquidate((File)domainDir);
            throw new DomainException(ex);
        }
    }
}

