/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.testing;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.testing.Environment;
import org.glassfish.admin.rest.testing.ObjectValue;
import org.glassfish.admin.rest.testing.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public abstract class ResourceInvoker {
    public static final String METHOD_OPTIONS = "options";
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    public static final String METHOD_PUT = "put";
    public static final String METHOD_DELETE = "delete";
    private final Environment env;
    private String password = null;
    private String uri;
    private Map<String, String> queryParams = new HashMap<String, String>();
    private String url = null;
    private String baseUrl = null;
    private String protocol = null;
    private String host = null;
    private String port = null;
    private String username = null;
    private JSONObject body = new JSONObject();

    protected ResourceInvoker(Environment env) {
        this.env = env;
    }

    protected Environment getEnvironment() {
        return this.env;
    }

    protected abstract String getContextRoot();

    protected abstract String getResourceRoot();

    protected abstract String getMediaType();

    protected String getRequestBodyMediaType() {
        return this.getMediaType();
    }

    protected String getResponseBodyMediaType() {
        return this.getMediaType();
    }

    protected String getUrl() {
        return this.url == null ? this.getBaseUrl() + "/" + this.getUri() : this.url;
    }

    public ResourceInvoker url(String val) {
        this.url = val;
        return this;
    }

    protected String getBaseUrl() {
        if (this.baseUrl != null) {
            return this.baseUrl;
        }
        return this.getProtocol() + "://" + this.getHost() + ":" + this.getPort() + "/" + this.getContextRoot() + "/" + this.getResourceRoot();
    }

    public ResourceInvoker baseUrl(String val) {
        this.baseUrl = val;
        return this;
    }

    protected String getProtocol() {
        return this.protocol == null ? this.getEnvironment().getProtocol() : this.protocol;
    }

    public ResourceInvoker protocol(String val) {
        this.protocol = val;
        return this;
    }

    protected String getHost() {
        return this.host == null ? this.getEnvironment().getHost() : this.host;
    }

    public ResourceInvoker host(String val) {
        this.host = val;
        return this;
    }

    protected String getPort() {
        return this.port == null ? this.getEnvironment().getPort() : this.port;
    }

    public ResourceInvoker port(String val) {
        this.port = val;
        return this;
    }

    protected String getUserName() {
        return this.username == null ? this.getEnvironment().getUserName() : this.username;
    }

    public ResourceInvoker username(String val) {
        this.username = val;
        return this;
    }

    protected String getPassword() {
        return this.password == null ? this.getEnvironment().getPassword() : this.password;
    }

    public ResourceInvoker password(String val) {
        this.password = val;
        return this;
    }

    protected String getUri() {
        return this.uri;
    }

    public ResourceInvoker uri(String val) {
        this.uri = val;
        return this;
    }

    protected Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public ResourceInvoker queryParam(String name, String value) {
        this.queryParams.put(name, value);
        return this;
    }

    protected JSONObject getBody() {
        return this.body;
    }

    public ResourceInvoker body(JSONObject val) {
        this.body = val;
        return this;
    }

    public ResourceInvoker body(ObjectValue val) throws Exception {
        return this.body(val.toJSONObject());
    }

    public Response options() throws Exception {
        return this.wrapResponse(METHOD_OPTIONS, this.getInvocationBuilder().options());
    }

    public Response get() throws Exception {
        return this.wrapResponse(METHOD_GET, this.getInvocationBuilder().get());
    }

    public Response post() throws Exception {
        return this.wrapResponse(METHOD_POST, this.getInvocationBuilder().post(this.getRequestBody()));
    }

    public Response put() throws Exception {
        return this.wrapResponse(METHOD_PUT, this.getInvocationBuilder().put(this.getRequestBody()));
    }

    public Response delete() throws Exception {
        return this.wrapResponse(METHOD_DELETE, this.getInvocationBuilder().delete());
    }

    private Invocation.Builder getInvocationBuilder() throws Exception {
        Client client = this.customizeClient(ClientBuilder.newClient());
        client.register((Object)HttpAuthenticationFeature.basic((String)this.getUserName(), (String)this.getPassword()));
        WebTarget target = client.target(this.getUrl());
        for (Map.Entry<String, String> e : this.getQueryParams().entrySet()) {
            target = target.queryParam(e.getKey(), new Object[]{e.getValue()});
        }
        return target.request(new String[]{this.getResponseBodyMediaType()}).header("X-Include-Resource-Links", (Object)"true").header("X-Requested-By", (Object)"MyClient");
    }

    protected Client customizeClient(Client client) {
        return client;
    }

    protected Response wrapResponse(String method, jakarta.ws.rs.core.Response response) throws Exception {
        return new Response(method, response);
    }

    private Entity getRequestBody() throws Exception {
        return Entity.entity((Object)this.getBody().toString(), (String)this.getRequestBodyMediaType());
    }
}

