/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.testing;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.testing.ArrayValue;
import org.glassfish.admin.rest.testing.Common;
import org.glassfish.admin.rest.testing.DataVerifier;
import org.glassfish.admin.rest.testing.Environment;
import org.glassfish.admin.rest.testing.ObjectValue;
import org.glassfish.admin.rest.testing.Response;
import org.glassfish.admin.rest.testing.StringValue;

public class ResponseVerifier {
    private Environment env;
    private Response response;

    public ResponseVerifier(Environment env, Response response) {
        this.env = env;
        this.response = response;
    }

    protected Environment getEnvironment() {
        return this.env;
    }

    public Response getResponse() {
        return this.response;
    }

    public ResponseVerifier status(int ... statuses) {
        if (statuses == null || statuses.length == 0) {
            statuses = new int[]{this.getDefaultStatus()};
        }
        int have = this.getResponse().getStatus();
        this.debug("Statuses want : " + Arrays.toString(statuses));
        this.debug("Status have : " + have);
        for (int want : statuses) {
            if (want != -1 && want != have) continue;
            this.debug("Received expected status code: " + want);
            return this;
        }
        throw new IllegalArgumentException("Unexpected status code.  want=" + Arrays.toString(statuses) + ", have=" + have + ", body=" + this.getResponse().getStringBody());
    }

    protected int getDefaultStatus() {
        String method = this.getResponse().getMethod();
        if ("options".equals(method)) {
            return Common.SC_OK;
        }
        if ("get".equals(method)) {
            return Common.SC_OK;
        }
        if ("post".equals(method)) {
            return Common.SC_CREATED;
        }
        if ("put".equals(method)) {
            return Common.SC_OK;
        }
        if ("delete".equals(method)) {
            return Common.SC_OK;
        }
        throw new AssertionError((Object)("Unknown Method: " + method));
    }

    public ResponseVerifier locationHeader(String uriWant) throws Exception {
        StringValue stringWant = new StringValue();
        stringWant.regexp(".*" + uriWant);
        return this.locationHeader(stringWant);
    }

    public ResponseVerifier locationHeader(StringValue stringWant) throws Exception {
        return this.header("Location", stringWant);
    }

    public ResponseVerifier xLocationHeader(String uriWant) throws Exception {
        StringValue stringWant = new StringValue();
        stringWant.regexp(".*" + uriWant);
        return this.xLocationHeader(stringWant);
    }

    public ResponseVerifier xLocationHeader(StringValue stringWant) throws Exception {
        return this.header("X-Location", stringWant);
    }

    public ResponseVerifier header(String name, StringValue want) throws Exception {
        ObjectValue objectWant = new ObjectValue();
        objectWant.ignoreExtra();
        ArrayValue valuesWant = new ArrayValue();
        valuesWant.add(want);
        objectWant.put(name, valuesWant);
        return this.headers(objectWant);
    }

    public ResponseVerifier headers(ObjectValue objectWant) throws Exception {
        JSONObject objectHave = new JSONObject();
        for (Map.Entry header : this.getResponse().getJaxrsResponse().getStringHeaders().entrySet()) {
            String name = (String)header.getKey();
            JSONArray values = new JSONArray();
            for (String value : (List)header.getValue()) {
                values.put((Object)value);
            }
            objectHave.put(name, (Object)values);
        }
        this.verifyData(objectWant, objectHave);
        return this;
    }

    public ResponseVerifier body(ObjectValue objectWant) throws Exception {
        this.verifyData(objectWant, this.getResponse().getJsonBody());
        return this;
    }

    public ResponseVerifier body(StringValue want) throws Exception {
        ObjectValue objectWant = new ObjectValue();
        objectWant.put("string", want);
        JSONObject objectHave = new JSONObject();
        objectHave.put("string", (Object)this.getResponse().getStringBody());
        this.verifyData(objectWant, objectHave);
        return this;
    }

    private void verifyData(ObjectValue want, JSONObject have) throws Exception {
        DataVerifier.verify(this.getEnvironment(), want, have);
    }

    private void debug(String message) {
        this.getEnvironment().debug(message);
    }
}

