/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.common.ActionReporter;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.RestRedirect;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
public class TemplateResource {
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected Habitat habitat;
    protected Dom entity;
    protected Dom parent;
    protected String tagName;
    protected ConfigModel childModel;
    protected String childID;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TemplateResource.class);
    private static final List<String> attributesToSkip = new ArrayList<String>(){
        {
            this.add("parent");
            this.add("name");
            this.add("children");
            this.add("submit");
        }
    };

    @GET
    public ActionReportResult getEntity(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        if (this.childModel == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return this.buildActionReportResult(true);
    }

    @POST
    public Response createEntity(HashMap<String, String> data) {
        try {
            this.removeAttributesToBeSkipped(data);
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return Response.status((int)400).entity((Object)ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, errorMessage, this.requestHeaders, this.uriInfo)).build();
            }
            ResourceUtil.purgeEmptyEntries(data);
            if ("__deleteoperation".equals(data.get("operation"))) {
                data.remove("operation");
                return this.delete(data);
            }
            ActionReporter ar = Util.applyChanges(data = ResourceUtil.translateCamelCasedNamesToXMLNames(data), this.uriInfo, this.habitat);
            if (ar.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                return Response.status((int)400).entity((Object)ResourceUtil.getActionReportResult((ActionReport)ar, "Could not apply changes" + ar.getMessage(), this.requestHeaders, this.uriInfo)).build();
            }
            String successMessage = localStrings.getLocalString("rest.resource.update.message", "\"{0}\" updated successfully.", new Object[]{this.uriInfo.getAbsolutePath()});
            return Response.ok((Object)ResourceUtil.getActionReportResult((ActionReport)ar, successMessage, this.requestHeaders, this.uriInfo)).build();
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ValidationException) {
                return Response.status((int)400).entity((Object)ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, ex.getMessage(), this.requestHeaders, this.uriInfo)).build();
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response post(FormDataMultiPart formData) {
        HashMap<String, String> data = TemplateResource.createDataBasedOnForm(formData);
        return this.createEntity(data);
    }

    @DELETE
    public Response delete(HashMap<String, String> data) {
        if (this.entity == null) {
            String errorMessage = localStrings.getLocalString("rest.resource.erromessage.noentity", "Resource not found.");
            return Response.status((int)404).entity((Object)ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, errorMessage, this.requestHeaders, this.uriInfo)).build();
        }
        if (this.getDeleteCommand() == null) {
            String message = localStrings.getLocalString("rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.", new Object[]{this.uriInfo.getAbsolutePath()});
            return Response.status((int)403).entity((Object)ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, message, this.requestHeaders, this.uriInfo)).build();
        }
        if (this.getDeleteCommand().equals("GENERIC-DELETE")) {
            try {
                ConfigBean p = (ConfigBean)this.parent;
                if (this.parent == null) {
                    p = (ConfigBean)this.entity.parent();
                }
                ConfigSupport.deleteChild((ConfigBean)p, (ConfigBean)((ConfigBean)this.entity));
                String successMessage = localStrings.getLocalString("rest.resource.delete.message", "\"{0}\" deleted successfully.", new Object[]{this.uriInfo.getAbsolutePath()});
                return Response.ok((Object)ResourceUtil.getActionReportResult(ActionReport.ExitCode.SUCCESS, successMessage, this.requestHeaders, this.uriInfo)).build();
            }
            catch (TransactionFailure ex) {
                throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return Response.status((int)400).entity((Object)ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, errorMessage, this.requestHeaders, this.uriInfo)).build();
            }
            ResourceUtil.addQueryString((MultivaluedMap<String, String>)this.uriInfo.getQueryParameters(), data);
            ResourceUtil.purgeEmptyEntries(data);
            ResourceUtil.adjustParameters(data);
            if (data.get("DEFAULT") == null) {
                this.addDefaultParameter(data);
            } else {
                String resourceName = this.getResourceName(this.uriInfo.getAbsolutePath().getPath(), "/");
                if (!data.get("DEFAULT").equals(resourceName)) {
                    String errorMessage = localStrings.getLocalString("rest.resource.not.deleted", "Resource not deleted. Value of \"name\" should be the name of this resource.");
                    return Response.status((int)403).entity((Object)ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, errorMessage, this.requestHeaders, this.uriInfo)).build();
                }
            }
            ActionReport actionReport = this.runCommand(this.getDeleteCommand(), data);
            if (actionReport != null) {
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode != ActionReport.ExitCode.FAILURE) {
                    String successMessage = localStrings.getLocalString("rest.resource.delete.message", "\"{0}\" deleted successfully.", new Object[]{this.uriInfo.getAbsolutePath()});
                    return Response.ok((Object)ResourceUtil.getActionReportResult(actionReport, successMessage, this.requestHeaders, this.uriInfo)).build();
                }
                String errorMessage = actionReport.getMessage();
                return Response.status((int)400).entity((Object)ResourceUtil.getActionReportResult(actionReport, errorMessage, this.requestHeaders, this.uriInfo)).build();
            }
            String message = localStrings.getLocalString("rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.", new Object[]{this.uriInfo.getAbsolutePath()});
            return Response.status((int)400).entity((Object)ResourceUtil.getActionReportResult(actionReport, message, this.requestHeaders, this.uriInfo)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @OPTIONS
    public Response options() {
        return Response.ok((Object)this.buildActionReportResult(false)).build();
    }

    public void setEntity(Dom p) {
        this.entity = p;
        this.childModel = p.model;
    }

    public Dom getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        if (parent == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.parent = parent;
        this.tagName = tagName;
        this.entity = parent.nodeElement(tagName);
        if (this.entity != null) {
            this.childModel = this.entity.model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDataBasedOnForm(FormDataMultiPart formData) {
        HashMap data = new HashMap();
        try {
            Map m1 = formData.getFields();
            Set ss = m1.keySet();
            for (String fieldName : ss) {
                for (FormDataBodyPart bodyPart : formData.getFields(fieldName)) {
                    if (bodyPart.getContentDisposition().getFileName() == null) continue;
                    InputStream fileStream = (InputStream)bodyPart.getValueAs(InputStream.class);
                    String mimeType = bodyPart.getMediaType().toString();
                    String fileName = bodyPart.getContentDisposition().getFileName();
                    if (fileName.contains("/")) {
                        fileName = Util.getName(fileName, '/');
                    } else if (fileName.contains("\\")) {
                        fileName = Util.getName(fileName, '\\');
                    }
                    Util.deleteFile(fileName, mimeType, fileStream);
                    return;
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TemplateResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            formData.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> createDataBasedOnForm(FormDataMultiPart formData) {
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            Map m1 = formData.getFields();
            Set ss = m1.keySet();
            for (String fieldName : ss) {
                for (FormDataBodyPart bodyPart : formData.getFields(fieldName)) {
                    if (bodyPart.getContentDisposition().getFileName() != null) {
                        InputStream fileStream = (InputStream)bodyPart.getValueAs(InputStream.class);
                        String mimeType = bodyPart.getMediaType().toString();
                        String fileName = bodyPart.getContentDisposition().getFileName();
                        if (fileName.contains("/")) {
                            fileName = Util.getName(fileName, '/');
                        } else if (fileName.contains("\\")) {
                            fileName = Util.getName(fileName, '\\');
                        }
                        File f = Util.saveFile(fileName, mimeType, fileStream);
                        f.deleteOnExit();
                        data.put(fieldName, f.getAbsolutePath());
                        continue;
                    }
                    data.put(fieldName, bodyPart.getValue());
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TemplateResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        return data;
    }

    public void setBeanByKey(List<Dom> parentList, String id) {
        if (parentList != null) {
            for (Dom c : parentList) {
                String keyvalue;
                String keyAttributeName = null;
                ConfigModel model = c.model;
                if (model.key == null) {
                    try {
                        for (String s : model.getAttributeNames()) {
                            if (!s.equals("name")) continue;
                            keyAttributeName = s;
                        }
                        if (keyAttributeName == null) {
                            keyAttributeName = (String)model.getAttributeNames().iterator().next();
                        }
                    }
                    catch (Exception e) {
                        keyAttributeName = "ThisIsAModelBug:NoKeyAttr";
                    }
                } else {
                    keyAttributeName = model.key.substring(1, model.key.length());
                }
                if (!(keyvalue = c.attribute(keyAttributeName.toLowerCase(Locale.US))).equals(id)) continue;
                this.setEntity((Dom)((ConfigBean)c));
            }
        }
    }

    protected ActionReportResult buildActionReportResult(boolean showEntityValues) {
        RestActionReporter ar = new RestActionReporter();
        ar.setExtraProperties(new Properties());
        ConfigBean entity = (ConfigBean)this.getEntity();
        if (this.childID != null) {
            ar.setActionDescription(this.childID);
        } else if (this.childModel != null) {
            ar.setActionDescription(this.childModel.getTagName());
        }
        if (showEntityValues && entity != null) {
            ar.getExtraProperties().put("entity", this.getAttributes((Dom)entity));
        }
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        Map<String, MethodMetaData> mmd = this.getMethodMetaData();
        optionsResult.putMethodMetaData("GET", mmd.get("GET"));
        optionsResult.putMethodMetaData("POST", mmd.get("POST"));
        optionsResult.putMethodMetaData("DELETE", mmd.get("DELETE"));
        ResourceUtil.addMethodMetaData((ActionReport)ar, mmd);
        if (entity != null) {
            ar.getExtraProperties().put("childResources", ResourceUtil.getResourceLinks((Dom)entity, this.uriInfo, ResourceUtil.canShowDeprecatedItems(this.habitat)));
        }
        ar.getExtraProperties().put("commands", ResourceUtil.getCommandLinks(this.getCommandResourcesPaths()));
        return new ActionReportResult(ar, entity, optionsResult);
    }

    protected void removeAttributesToBeSkipped(Map<String, String> data) {
        for (String item : attributesToSkip) {
            data.remove(item);
        }
    }

    protected String[][] getCommandResourcesPaths() {
        return new String[0][];
    }

    protected String getDeleteCommand() {
        if (this.entity == null) {
            return null;
        }
        return ResourceUtil.getCommand(RestRedirect.OpType.DELETE, this.getEntity().model);
    }

    private ActionReport runCommand(String commandName, HashMap<String, String> data) {
        if (commandName != null) {
            String typeOfResult = ResourceUtil.getResultType(this.requestHeaders);
            return ResourceUtil.runCommand(commandName, data, this.habitat, typeOfResult);
        }
        return null;
    }

    private void addDefaultParameter(HashMap<String, String> data) {
        String defaultParameterValue = this.getEntity().getKey();
        if (defaultParameterValue == null) {
            defaultParameterValue = this.parent.getKey();
        }
        data.put("DEFAULT", defaultParameterValue);
    }

    private String getResourceName(String absoluteName, String delimiter) {
        if (null == absoluteName) {
            return absoluteName;
        }
        int index = absoluteName.lastIndexOf(delimiter);
        if (index != -1) {
            return absoluteName.substring(index += delimiter.length());
        }
        return absoluteName;
    }

    private Map<String, String> getAttributes(Dom entity) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        Set attributeNames = entity.model.getAttributeNames();
        for (String attributeName : attributeNames) {
            result.put(Util.eleminateHypen(attributeName), entity.attribute(attributeName));
        }
        return result;
    }

    private Map<String, MethodMetaData> getMethodMetaData() {
        TreeMap<String, MethodMetaData> map = new TreeMap<String, MethodMetaData>();
        map.put("GET", new MethodMetaData());
        MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData(this.childModel);
        map.put("POST", postMethodMetaData);
        String command = this.getDeleteCommand();
        if (command != null) {
            MethodMetaData deleteMethodMetaData;
            if (command.equals("GENERIC-DELETE")) {
                deleteMethodMetaData = new MethodMetaData();
            } else {
                deleteMethodMetaData = ResourceUtil.getMethodMetaData(command, this.habitat, RestService.logger);
                deleteMethodMetaData.removeParamMetaData("id");
            }
            map.put("DELETE", deleteMethodMetaData);
        }
        return map;
    }
}

