/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.jersey.api.container.filter.LoggingFilter;
import com.sun.jersey.api.core.ResourceConfig;
import java.beans.PropertyChangeEvent;
import org.glassfish.admin.rest.RestConfig;
import org.glassfish.admin.rest.adapter.Reloader;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

public class RestConfigChangeListener
implements ConfigListener {
    private Reloader r;
    private ResourceConfig rc;
    private ServerContext sc;
    private Habitat habitat;

    public RestConfigChangeListener(Habitat habitat, Reloader reload, ResourceConfig rc, ServerContext sc) {
        this.r = reload;
        this.rc = rc;
        this.sc = sc;
        this.habitat = habitat;
        RestConfig target = RestConfigChangeListener.getRestConfig(habitat);
        if (target != null) {
            ((ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)target)).addListener((ConfigListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader apiClassLoader = this.sc.getCommonClassLoader();
            Thread.currentThread().setContextClassLoader(apiClassLoader);
            this.rc.getContainerResponseFilters().clear();
            this.rc.getContainerRequestFilters().clear();
            this.rc.getFeatures().put("com.sun.jersey.config.feature.DisableWADL", Boolean.FALSE);
            RestConfig restConf = RestConfigChangeListener.getRestConfig(this.habitat);
            if (restConf != null) {
                if (restConf.getLogOutput().equalsIgnoreCase("true")) {
                    this.rc.getContainerResponseFilters().add(LoggingFilter.class);
                }
                if (restConf.getLogInput().equalsIgnoreCase("true")) {
                    this.rc.getContainerRequestFilters().add(LoggingFilter.class);
                }
                if (restConf.getWadlGeneration().equalsIgnoreCase("false")) {
                    this.rc.getFeatures().put("com.sun.jersey.config.feature.DisableWADL", Boolean.TRUE);
                }
            }
            this.r.reload();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
        return null;
    }

    public static RestConfig getRestConfig(Habitat habitat) {
        Config config;
        if (habitat == null) {
            return null;
        }
        Domain domain = (Domain)habitat.getComponent(Domain.class);
        if (domain != null && (config = domain.getConfigNamed("server-config")) != null) {
            return (RestConfig)config.getExtensionByType(RestConfig.class);
        }
        return null;
    }
}

