/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.client.utils;

import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class Util {
    public static Map<String, Object> processJsonMap(String json) {
        HashMap<String, Object> map;
        try {
            map = Util.processJsonObject(new JSONObject(json));
        }
        catch (JSONException e) {
            map = new HashMap<String, Object>();
        }
        return map;
    }

    public static Map processJsonObject(JSONObject jo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Iterator i = jo.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object value = jo.get(key);
                if (value instanceof JSONArray) {
                    map.put(key, Util.processJsonArray((JSONArray)value));
                    continue;
                }
                if (value instanceof JSONObject) {
                    map.put(key, Util.processJsonObject((JSONObject)value));
                    continue;
                }
                map.put(key, value);
            }
        }
        catch (JSONException e) {
            LogDomains.getLogger(Util.class, (String)"javax.enterprise.system.tools.admin").log(Level.INFO, "rest.json_parsing_exception", e.getLocalizedMessage());
        }
        return map;
    }

    public static List processJsonArray(JSONArray ja) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            for (int i = 0; i < ja.length(); ++i) {
                Object entry = ja.get(i);
                if (entry instanceof JSONArray) {
                    results.add(Util.processJsonArray((JSONArray)entry));
                    continue;
                }
                if (entry instanceof JSONObject) {
                    results.add(Util.processJsonObject((JSONObject)entry));
                    continue;
                }
                results.add(entry);
            }
        }
        catch (JSONException e) {
            LogDomains.getLogger(Util.class, (String)"javax.enterprise.system.tools.admin").log(Level.INFO, "rest.json_parsing_exception", e.getLocalizedMessage());
        }
        return results;
    }
}

