/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.CsrfProtectionFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;

public class RestClient {
    protected String host;
    protected int port;
    protected Client client;
    protected boolean useSsl = false;

    public RestClient() {
        this("localhost", 4848, false, null, null);
    }

    public RestClient(String host, int port, boolean useSsl) {
        this(host, port, useSsl, null, null);
    }

    public RestClient(String host, int port, boolean useSsl, String user, String password) {
        this.host = host;
        this.port = port;
        this.useSsl = useSsl;
        this.client = Client.create();
        this.client.addFilter((ClientFilter)new CsrfProtectionFilter());
        if (user != null) {
            this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(user, password));
        }
    }

    public String getRestUrl() {
        return (this.useSsl ? "https" : "http") + "://" + this.host + ":" + this.port + "/management";
    }
}

