/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class JavaConfig {
    private Map<String, String> map;

    JavaConfig(Map<String, String> map) {
        this.map = map;
    }

    Map<String, String> getMap() {
        return this.map;
    }

    String getJavaHome() {
        return this.map.get("java-home");
    }

    List<File> getEnvClasspath() {
        if (this.useEnvClasspath()) {
            String s = System.getenv("CLASSPATH");
            s = this.stripQuotes(s);
            return GFLauncherUtils.stringToFiles((String)s);
        }
        return new ArrayList<File>();
    }

    List<File> getPrefixClasspath() {
        String cp = this.map.get("classpath-prefix");
        if (GFLauncherUtils.ok((String)cp)) {
            return GFLauncherUtils.stringToFiles((String)cp);
        }
        return new ArrayList<File>();
    }

    String getNativeLibraryPrefix() {
        String s = this.map.get("native-library-path-prefix");
        if (!GFLauncherUtils.ok((String)s)) {
            s = "";
        }
        return s;
    }

    List<File> getSuffixClasspath() {
        String cp = this.map.get("classpath-suffix");
        if (GFLauncherUtils.ok((String)cp)) {
            return GFLauncherUtils.stringToFiles((String)cp);
        }
        return new ArrayList<File>();
    }

    String getNativeLibrarySuffix() {
        String s = this.map.get("native-library-path-suffix");
        if (!GFLauncherUtils.ok((String)s)) {
            s = "";
        }
        return s;
    }

    List<File> getSystemClasspath() {
        String cp = this.map.get("system-classpath");
        if (GFLauncherUtils.ok((String)cp)) {
            return GFLauncherUtils.stringToFiles((String)cp);
        }
        return new ArrayList<File>();
    }

    List<String> getDebugOptions() {
        List<String> empty = Collections.emptyList();
        String s = this.map.get("debug-options");
        if (!GFLauncherUtils.ok((String)s)) {
            return empty;
        }
        String[] ss = s.split(" ");
        if (ss == null || ss.length <= 0) {
            return empty;
        }
        return Arrays.asList(ss);
    }

    boolean isDebugEnabled() {
        return Boolean.parseBoolean(this.map.get("debug-enabled"));
    }

    private boolean useEnvClasspath() {
        String s = this.map.get("env-classpath-ignored");
        if (s == null || s.length() <= 0) {
            return false;
        }
        return !Boolean.parseBoolean(s);
    }

    private String stripQuotes(String s) {
        if (!this.hasQuotes(s)) {
            return s;
        }
        String s2 = this.stripChar(s, "'");
        s2 = this.stripChar(s2, "\"");
        GFLauncherLogger.severe("NCLS-GFLAUNCHER-00001", s, s2);
        return s2;
    }

    private boolean hasQuotes(String s) {
        if (s == null) {
            return false;
        }
        if (s.indexOf(39) >= 0) {
            return true;
        }
        return s.indexOf(34) >= 0;
    }

    private String stripChar(String s, String c) {
        String[] ss = s.split(c);
        StringBuilder sb = new StringBuilder();
        for (String s2 : ss) {
            sb.append(s2);
        }
        return sb.toString();
    }
}

