/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transports;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="grizzlyconfigupgrade")
public class GrizzlyConfigSchemaMigrator
implements ConfigurationUpgrade,
PostConstruct {
    private static final String SSL_CONFIGURATION_WANTAUTH = "org.glassfish.grizzly.ssl.auth";
    private static final String SSL_CONFIGURATION_SSLIMPL = "org.glassfish.grizzly.ssl.sslImplementation";
    @Inject
    private Configs configs;
    private Config currentConfig = null;
    @Inject
    private ServiceLocator habitat;
    private static final String HTTP_THREAD_POOL = "http-thread-pool";
    private static final String ASADMIN_LISTENER = "admin-listener";
    private static final String ASADMIN_VIRTUAL_SERVER = "__asadmin";
    static final Logger logger = ConfigApiLoggerInfo.getLogger();

    public void postConstruct() {
        Iterator<Config> i$ = this.configs.getConfig().iterator();
        while (i$.hasNext()) {
            Config config;
            this.currentConfig = config = i$.next();
            try {
                NetworkConfig networkConfig = this.currentConfig.getNetworkConfig();
                if (networkConfig == null) {
                    this.createFromScratch();
                }
                this.normalizeThreadPools();
                if (this.currentConfig.getHttpService() != null) {
                    this.promoteHttpServiceProperties(this.currentConfig.getHttpService());
                    this.promoteVirtualServerProperties(this.currentConfig.getHttpService());
                } else {
                    logger.log(Level.WARNING, "NCLS-CFGAPI-00101", new String[]{this.currentConfig.getName()});
                }
                this.promoteSystemProperties();
                this.addAsadminProtocol(this.currentConfig.getNetworkConfig());
            }
            catch (TransactionFailure tf) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00102", tf);
                throw new RuntimeException(tf);
            }
        }
    }

    private void addAsadminProtocol(NetworkConfig config) throws TransactionFailure {
        this.ensureAdminThreadPool();
        Protocols protocols = GrizzlyConfigSchemaMigrator.getProtocols(config);
        Protocol adminProtocol = protocols.findProtocol(ASADMIN_LISTENER);
        if (adminProtocol == null) {
            adminProtocol = (Protocol)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

                public Object run(Protocols param) throws TransactionFailure {
                    Protocol protocol = (Protocol)param.createChild(Protocol.class);
                    param.getProtocol().add(protocol);
                    protocol.setName(GrizzlyConfigSchemaMigrator.ASADMIN_LISTENER);
                    Http http = (Http)protocol.createChild(Http.class);
                    http.setFileCache((FileCache)http.createChild(FileCache.class));
                    protocol.setHttp(http);
                    http.setDefaultVirtualServer(GrizzlyConfigSchemaMigrator.ASADMIN_VIRTUAL_SERVER);
                    http.setMaxConnections("250");
                    return protocol;
                }
            }, (ConfigBeanProxy)protocols);
        }
        for (NetworkListener listener : adminProtocol.findNetworkListeners()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListener>(){

                public Object run(NetworkListener param) {
                    param.setThreadPool("admin-thread-pool");
                    return null;
                }
            }, (ConfigBeanProxy)listener);
        }
    }

    private void ensureAdminThreadPool() throws TransactionFailure {
        ThreadPools threadPools = this.currentConfig.getThreadPools();
        boolean adminThreadPoolFound = false;
        for (ThreadPool pool : threadPools.getThreadPool()) {
            adminThreadPoolFound |= "admin-thread-pool".equals(pool.getName());
        }
        if (!adminThreadPoolFound) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPools>(){

                public Object run(ThreadPools param) throws PropertyVetoException, TransactionFailure {
                    ThreadPool pool = (ThreadPool)param.createChild(ThreadPool.class);
                    param.getThreadPool().add(pool);
                    pool.setName("admin-thread-pool");
                    pool.setMaxThreadPoolSize("50");
                    pool.setMaxQueueSize("256");
                    return null;
                }
            }, (ConfigBeanProxy)threadPools);
        }
    }

    private void createFromScratch() throws TransactionFailure {
        this.normalizeThreadPools();
        this.getNetworkConfig();
    }

    private ThreadPools createThreadPools() throws TransactionFailure {
        return (ThreadPools)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

            public Object run(Config param) throws PropertyVetoException, TransactionFailure {
                ThreadPools threadPools = (ThreadPools)param.createChild(ThreadPools.class);
                param.setThreadPools(threadPools);
                return threadPools;
            }
        }, (ConfigBeanProxy)this.currentConfig);
    }

    private NetworkConfig getNetworkConfig() throws TransactionFailure {
        NetworkConfig config = this.currentConfig.getNetworkConfig();
        if (config == null) {
            config = (NetworkConfig)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                public Object run(Config param) throws PropertyVetoException, TransactionFailure {
                    NetworkConfig netConfig = (NetworkConfig)param.createChild(NetworkConfig.class);
                    netConfig.setProtocols((Protocols)netConfig.createChild(Protocols.class));
                    netConfig.setNetworkListeners((NetworkListeners)netConfig.createChild(NetworkListeners.class));
                    netConfig.setTransports((Transports)netConfig.createChild(Transports.class));
                    param.setNetworkConfig(netConfig);
                    return netConfig;
                }
            }, (ConfigBeanProxy)this.currentConfig);
        }
        return config;
    }

    public static Protocols getProtocols(NetworkConfig config) throws TransactionFailure {
        Protocols protocols = config.getProtocols();
        if (protocols == null) {
            protocols = (Protocols)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

                public Object run(NetworkConfig param) throws TransactionFailure {
                    Protocols child = (Protocols)param.createChild(Protocols.class);
                    param.setProtocols(child);
                    return child;
                }
            }, (ConfigBeanProxy)config);
        }
        return protocols;
    }

    private void migrateThreadPools(ThreadPools threadPools) throws TransactionFailure {
        Config config = (Config)threadPools.getParent(Config.class);
        NetworkListeners networkListeners = config.getNetworkConfig().getNetworkListeners();
        threadPools.getThreadPool().addAll(networkListeners.getThreadPool());
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

            public Object run(NetworkListeners param) {
                param.getThreadPool().clear();
                return null;
            }
        }, (ConfigBeanProxy)networkListeners);
    }

    private void normalizeThreadPools() throws TransactionFailure {
        NetworkListeners networkListeners;
        ThreadPools threadPools = this.currentConfig.getThreadPools();
        if (threadPools == null) {
            threadPools = this.createThreadPools();
        } else {
            List<ThreadPool> list = threadPools.getThreadPool();
            boolean httpListenerFound = false;
            for (ThreadPool pool : list) {
                httpListenerFound |= HTTP_THREAD_POOL.equals(pool.getThreadPoolId()) || HTTP_THREAD_POOL.equals(pool.getName());
                if (pool.getName() != null) continue;
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPool>(){

                    public Object run(ThreadPool param) {
                        param.setName(param.getThreadPoolId());
                        param.setThreadPoolId(null);
                        if (param.getMinThreadPoolSize() == null || Integer.parseInt(param.getMinThreadPoolSize()) < 2) {
                            param.setMinThreadPoolSize("2");
                        }
                        return null;
                    }
                }, (ConfigBeanProxy)pool);
            }
            if (!httpListenerFound) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPools>(){

                    public Object run(ThreadPools param) throws TransactionFailure {
                        ThreadPool pool = (ThreadPool)param.createChild(ThreadPool.class);
                        pool.setName(GrizzlyConfigSchemaMigrator.HTTP_THREAD_POOL);
                        param.getThreadPool().add(pool);
                        return null;
                    }
                }, (ConfigBeanProxy)threadPools);
            }
        }
        NetworkConfig networkConfig = this.currentConfig.getNetworkConfig();
        if (networkConfig != null && (networkListeners = networkConfig.getNetworkListeners()) != null && networkListeners.getThreadPool() != null && !networkListeners.getThreadPool().isEmpty()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPools>(){

                public Object run(ThreadPools param) throws TransactionFailure {
                    GrizzlyConfigSchemaMigrator.this.migrateThreadPools(param);
                    return null;
                }
            }, (ConfigBeanProxy)threadPools);
        }
    }

    private void promoteHttpServiceProperties(HttpService service) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) {
                ArrayList<Property> propertyList = new ArrayList<Property>(param.getProperty());
                Iterator it = propertyList.iterator();
                while (it.hasNext()) {
                    Property property = (Property)it.next();
                    if ("accessLoggingEnabled".equals(property.getName())) {
                        param.setAccessLoggingEnabled(property.getValue());
                        it.remove();
                        continue;
                    }
                    if ("accessLogBufferSize".equals(property.getName())) {
                        param.getAccessLog().setBufferSizeBytes(property.getValue());
                        it.remove();
                        continue;
                    }
                    if ("accessLogWriterInterval".equals(property.getName())) {
                        param.getAccessLog().setWriteIntervalSeconds(property.getValue());
                        it.remove();
                        continue;
                    }
                    if (!"sso-enabled".equals(property.getName())) continue;
                    param.setSsoEnabled(property.getValue());
                    it.remove();
                }
                param.getProperty().clear();
                param.getProperty().addAll(propertyList);
                return null;
            }
        }, (ConfigBeanProxy)service);
    }

    private void promoteSystemProperties() throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JavaConfig>(){

            public Object run(JavaConfig param) throws PropertyVetoException, TransactionFailure {
                ArrayList props = new ArrayList(param.getJvmOptions());
                Iterator iterator = props.iterator();
                while (iterator.hasNext()) {
                    String prop = (String)iterator.next();
                    if (!prop.startsWith("-D")) continue;
                    String[] parts = prop.split("=");
                    String name = parts[0].substring(2);
                    if (GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_WANTAUTH.equals(name) || GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_SSLIMPL.equals(name)) {
                        iterator.remove();
                        GrizzlyConfigSchemaMigrator.this.updateSsl(name, parts[1]);
                    }
                    if (!"com.sun.grizzly.maxTransactionTimeout".equals(name)) continue;
                    iterator.remove();
                    GrizzlyConfigSchemaMigrator.this.updateHttp(parts[1]);
                }
                param.setJvmOptions(props);
                return param;
            }
        }, (ConfigBeanProxy)((ConfigBeanProxy)this.habitat.getService(JavaConfig.class, new Annotation[0])));
    }

    private void promoteVirtualServerProperties(HttpService service) throws TransactionFailure {
        for (VirtualServer virtualServer : service.getVirtualServer()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<VirtualServer>(){

                public Object run(VirtualServer param) throws PropertyVetoException {
                    if (param.getHttpListeners() != null && !"".equals(param.getHttpListeners())) {
                        param.setNetworkListeners(param.getHttpListeners());
                    }
                    param.setHttpListeners(null);
                    ArrayList<Property> propertyList = new ArrayList<Property>(param.getProperty());
                    Iterator it = propertyList.iterator();
                    while (it.hasNext()) {
                        Property property = (Property)it.next();
                        if ("docroot".equals(property.getName())) {
                            param.setDocroot(property.getValue());
                            it.remove();
                            continue;
                        }
                        if ("accesslog".equals(property.getName())) {
                            param.setAccessLog(property.getValue());
                            it.remove();
                            continue;
                        }
                        if (!"sso-enabled".equals(property.getName())) continue;
                        param.setSsoEnabled(property.getValue());
                        it.remove();
                    }
                    param.getProperty().clear();
                    param.getProperty().addAll(propertyList);
                    return null;
                }
            }, (ConfigBeanProxy)virtualServer);
        }
    }

    private void updateHttp(final String maxTransactionTimeout) throws TransactionFailure {
        for (Protocol protocol : this.currentConfig.getNetworkConfig().getProtocols().getProtocol()) {
            Http http = protocol.getHttp();
            if (http == null) continue;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                public Object run(Http param) {
                    if (param != null) {
                        param.setRequestTimeoutSeconds(maxTransactionTimeout);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)http);
        }
    }

    private void updateSsl(final String propName, final String value) throws TransactionFailure {
        List protocols = this.habitat.getAllServices(Protocol.class, new Annotation[0]);
        for (Protocol protocol : protocols) {
            Ssl ssl = protocol.getSsl();
            if (ssl == null) continue;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Ssl>(){

                public Object run(Ssl param) {
                    if (GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_WANTAUTH.equals(propName)) {
                        param.setClientAuth(value);
                    } else if (GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_SSLIMPL.equals(propName)) {
                        param.setClassname(value);
                    }
                    return param;
                }
            }, (ConfigBeanProxy)ssl);
        }
    }
}

