/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.util.ColumnFormatter;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.common.util.admin.GenericCommandModel;
import org.glassfish.config.support.GenericCrudCommand;
import org.glassfish.config.support.Listing;
import org.glassfish.config.support.ListingColumn;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

@PerLookup
public class GenericListCommand
extends GenericCrudCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    @Param(primary=true, optional=true)
    String name;
    @Param(name="long", shortName="l", defaultValue="false", optional=true)
    boolean longOpt;
    @Param(name="header", shortName="h", defaultValue="true", optional=true)
    boolean headerOpt;
    @Param(name="output", shortName="o", optional=true)
    String[] outputOpts;
    CommandModel cmdModel;
    ConfigModel targetModel;
    Listing listing;
    private ConfigBeanProxy parentBean;

    @Override
    public void postConstruct() {
        super.postConstruct();
        this.listing = this.targetMethod.getAnnotation(Listing.class);
        this.resolverType = this.listing.resolver();
        try {
            this.cmdModel = new GenericCommandModel(this.targetType, false, null, this.listing.i18n(), (LocalStringManager)new LocalStringManagerImpl(this.targetType), (DomDocument)this.habitat.getService(DomDocument.class, new Annotation[0]), this.commandName, false, new Class[]{this.listing.resolver(), GenericListCommand.class});
            this.targetModel = ((DomDocument)this.habitat.getService(DomDocument.class, new Annotation[0])).buildModel(this.targetType);
            if (logger.isLoggable(this.level)) {
                for (String paramName : this.cmdModel.getParametersNames()) {
                    CommandModel.ParamModel param = this.cmdModel.getModelFor(paramName);
                    logger.log(Level.FINE, "I take {0} parameters", param.getName());
                }
            }
        }
        catch (Exception e) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.command_model_exception", "Exception while creating the command model for the generic command {0} : {1}", new Object[]{this.commandName, e.getMessage()});
            logger.severe(msg);
            throw new RuntimeException(msg, e);
        }
    }

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> checks = new ArrayList<AccessRequired.AccessCheck>();
        checks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)this.parentBean), "read"));
        if (this.longOpt) {
            try {
                List children = (List)this.targetMethod.invoke((Object)this.parentBean, new Object[0]);
                for (ConfigBeanProxy child : children) {
                    if (this.name != null && !this.name.equals(Dom.unwrap((ConfigBeanProxy)child).getKey())) continue;
                    checks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)child), "read"));
                }
            }
            catch (Exception ex) {
                String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericListCommand.accesschecks", "Exception while creating access checks for generic command {0}: {1}", new Object[]{this.commandName, ex.getMessage()});
                logger.severe(msg);
                throw new RuntimeException(msg, ex);
            }
        }
        return checks;
    }

    @Override
    void prepareInjection(AdminCommandContext ctx) {
        super.prepareInjection(ctx);
        this.parentBean = this.resolver.resolve(ctx, this.parentType);
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.parentBean == null) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.target_object_not_found", "The CrudResolver {0} could not find the configuration object of type {1} where instances of {2} should be added", new Object[]{this.resolver.getClass().toString(), this.parentType, this.targetType});
            report.failure(logger, msg);
            return;
        }
        if (this.outputOpts != null) {
            this.longOpt = true;
        }
        List<ColumnInfo> cols = null;
        ColumnFormatter colfm = null;
        if (this.longOpt) {
            cols = this.getColumnInfo(this.targetType);
            if (!this.isOutputOptsValid(cols, this.outputOpts)) {
                String collist = this.arrayToString(this.getColumnHeadings(cols));
                String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericListCommand.invalidOutputOpts", "Invalid output option. Choose from the following columns: {0}", new Object[]{collist});
                report.failure(logger, msg);
                return;
            }
            cols = this.filterColumns(cols, this.outputOpts);
            Collections.sort(cols, new Comparator<ColumnInfo>(){

                @Override
                public int compare(ColumnInfo o1, ColumnInfo o2) {
                    return Integer.valueOf(o1.order).compareTo(o2.order);
                }
            });
            colfm = this.headerOpt ? new ColumnFormatter(this.getColumnHeadings(cols)) : new ColumnFormatter();
        }
        ArrayList list = new ArrayList();
        Properties props = report.getExtraProperties();
        if (props == null) {
            props = new Properties();
            report.setExtraProperties(props);
        }
        try {
            List children = (List)this.targetMethod.invoke((Object)this.parentBean, new Object[0]);
            for (ConfigBeanProxy child : children) {
                if (this.name != null && !this.name.equals(Dom.unwrap((ConfigBeanProxy)child).getKey())) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (this.longOpt) {
                    Object[] data = this.getColumnData(child, cols);
                    colfm.addRow(data);
                    for (int i = 0; i < data.length; ++i) {
                        map.put(cols.get((int)i).xmlName, data[i]);
                    }
                } else {
                    Dom childDom = Dom.unwrap((ConfigBeanProxy)child);
                    String key = childDom.getKey();
                    if (key == null) {
                        String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericListCommand.element_has_no_key", "The element {0} has no key attribute", new Object[]{this.targetType});
                        report.failure(logger, msg);
                        return;
                    }
                    report.addSubActionsReport().setMessage(key);
                    map.put("key", key);
                }
                list.add(map);
            }
            if (this.longOpt) {
                report.appendMessage(colfm.toString());
            }
            if (!list.isEmpty()) {
                props.put(GenericListCommand.elementName(Dom.unwrap((ConfigBeanProxy)this.parentBean).document, this.parentType, this.targetType), list);
            }
        }
        catch (Exception e) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.method_invocation_exception", "Exception while invoking {0} method : {1}", new Object[]{this.targetMethod.toString(), e.toString()});
            report.failure(logger, msg, (Throwable)e);
        }
    }

    public CommandModel getModel() {
        return this.cmdModel;
    }

    private List<ColumnInfo> getColumnInfo(Class<? extends ConfigBeanProxy> clazz) {
        ArrayList<ColumnInfo> cols = new ArrayList<ColumnInfo>();
        for (String aname : this.targetModel.getAttributeNames()) {
            ColumnInfo ci = new ColumnInfo();
            ci.cprop = this.targetModel.findIgnoreCase(aname);
            ci.order = this.targetModel.key.equals("@" + aname) ? 0 : 1;
            ci.xmlName = aname;
            ci.heading = aname.toUpperCase(Locale.ENGLISH);
            cols.add(ci);
        }
        for (Method m : this.targetType.getMethods()) {
            ListingColumn lc = m.getAnnotation(ListingColumn.class);
            if (lc == null) continue;
            String cname = this.targetModel.camelCaseToXML(this.targetModel.trimPrefix(m.getName()));
            ColumnInfo mci = null;
            for (ColumnInfo ci : cols) {
                if (!cname.equalsIgnoreCase(ci.xmlName)) continue;
                mci = ci;
                break;
            }
            if (mci == null) {
                mci = new ColumnInfo();
                mci.xmlName = cname;
                mci.heading = cname.toUpperCase(Locale.ENGLISH);
                try {
                    mci.duckGetter = this.targetModel.getDuckMethod(m);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(GenericListCommand.class.getName()).log(Level.SEVERE, "Cannot identify getter method for ListingColumn", ex);
                }
                catch (NoSuchMethodException ex) {
                    Logger.getLogger(GenericListCommand.class.getName()).log(Level.SEVERE, "Cannot identify getter method for ListingColumn", ex);
                }
                cols.add(mci);
            }
            mci.lcAnn = lc;
            mci.order = lc.order();
            if (lc.header() == null || lc.header().length() <= 0) continue;
            mci.heading = lc.header();
        }
        return cols;
    }

    private List<ColumnInfo> filterColumns(List<ColumnInfo> cols, String[] outputOpts) {
        ArrayList<ColumnInfo> newcols = new ArrayList<ColumnInfo>(cols.size());
        for (ColumnInfo ci : cols) {
            if (!ci.isIncluded(outputOpts)) continue;
            newcols.add(ci);
        }
        return newcols;
    }

    private String[] getColumnHeadings(List<ColumnInfo> cols) {
        String[] rv = new String[cols.size()];
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = cols.get((int)i).heading;
        }
        return rv;
    }

    private String[] getColumnData(ConfigBeanProxy child, List<ColumnInfo> cols) {
        String[] rv = new String[cols.size()];
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = cols.get(i).getValue(child);
        }
        return rv;
    }

    private boolean isOutputOptsValid(List<ColumnInfo> cols, String[] outputOpts) {
        if (outputOpts == null) {
            return true;
        }
        for (int i = 0; i < outputOpts.length; ++i) {
            boolean found = false;
            for (ColumnInfo ci : cols) {
                if (ci.isExcluded() || !ci.heading.equalsIgnoreCase(outputOpts[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private String arrayToString(String[] a) {
        if (a == null || a.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            sb.append(", ").append(a[i]);
        }
        return sb.toString();
    }

    @Override
    public Class getDecoratorClass() {
        return null;
    }

    static class ColumnInfo {
        static final int KEY_ORDER = 0;
        static final int NONKEY_ORDER = 1;
        String heading;
        String xmlName;
        int order;
        ConfigModel.Property cprop;
        Method duckGetter;
        ListingColumn lcAnn;

        ColumnInfo() {
        }

        private String getValue(ConfigBeanProxy bean) {
            if (this.cprop != null) {
                return (String)this.cprop.get(Dom.unwrap((ConfigBeanProxy)bean), String.class);
            }
            if (this.duckGetter != null) {
                try {
                    return (String)this.duckGetter.invoke(null, bean);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(GenericListCommand.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(GenericListCommand.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(GenericListCommand.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return "";
        }

        private boolean isExcluded() {
            return this.lcAnn != null && this.lcAnn.exclude();
        }

        private boolean isIncluded(String[] outputOpts) {
            if (this.isExcluded()) {
                return false;
            }
            if (outputOpts == null || outputOpts.length == 0) {
                return this.lcAnn == null || this.lcAnn.inLongByDefault();
            }
            for (String s : outputOpts) {
                if (!s.equalsIgnoreCase(this.heading)) continue;
                return true;
            }
            return false;
        }
    }
}

