/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.customvalidators.ConfigRefConstraint;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Logger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.glassfish.api.admin.config.Named;

public class ConfigRefValidator
implements ConstraintValidator<ConfigRefConstraint, Named>,
Payload {
    static final Logger logger = ConfigApiLoggerInfo.getLogger();
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConfigRefValidator.class);

    public void initialize(ConfigRefConstraint constraint) {
    }

    public boolean isValid(Named bean, ConstraintValidatorContext constraintValidatorContext) {
        if (bean == null) {
            return true;
        }
        Server server = null;
        Cluster mycluster = null;
        String configRef = null;
        String serverName = null;
        if (bean instanceof Server) {
            server = (Server)bean;
            configRef = server.getConfigRef();
            serverName = server.getName();
        } else if (bean instanceof Cluster) {
            mycluster = (Cluster)bean;
            configRef = mycluster.getConfigRef();
            serverName = mycluster.getName();
        }
        if (configRef == null) {
            return true;
        }
        if (configRef.equals("default-config")) {
            logger.warning("NCLS-ADMIN-0014");
            return false;
        }
        if (server != null) {
            if (server.isDas() && !configRef.equals("server-config")) {
                logger.warning("NCLS-ADMIN-0015");
                return false;
            }
            if (!server.isDas() && configRef.equals("server-config")) {
                logger.warning("NCLS-ADMIN-0016");
                return false;
            }
            Servers servers = (Servers)server.getParent(Servers.class);
            Domain domain = (Domain)servers.getParent(Domain.class);
            Configs configs = domain.getConfigs();
            if (servers.getServer(serverName) != null) {
                Cluster cluster = domain.getClusterForInstance(serverName);
                if (cluster != null && !cluster.getConfigRef().equals(configRef)) {
                    logger.warning("NCLS-ADMIN-0017");
                    return false;
                }
                if (configs == null || configs.getConfigByName(configRef) == null) {
                    logger.warning("NCLS-ADMIN-0018");
                    return false;
                }
            }
        }
        return true;
    }
}

