/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.parser;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.parser.ConfigurationPopulator;
import com.sun.enterprise.config.serverbeans.ConfigLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class ConfigurationParser<C extends ConfigLoader> {
    private static final Logger LOG = Logger.getLogger(ConfigurationParser.class.getName());
    private static boolean replaceSystemProperties = false;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ConfigModularityUtils configModularityUtils;

    public <T extends ConfigBeanProxy> void parseAndSetConfigBean(List<ConfigBeanDefaultValue> values) {
        ConfigParser configParser = new ConfigParser(this.serviceLocator);
        DomDocument<GlassFishConfigBean> doc = new DomDocument<GlassFishConfigBean>(this.serviceLocator){

            public Dom make(ServiceLocator serviceLocator, XMLStreamReader xmlStreamReader, GlassFishConfigBean dom, ConfigModel configModel) {
                return new GlassFishConfigBean(serviceLocator, this, dom, configModel, xmlStreamReader);
            }
        };
        for (ConfigBeanDefaultValue configBeanDefaultValue : values) {
            String msg;
            LocalStringManagerImpl localStrings;
            ConfigBeanProxy parent = this.configModularityUtils.getOwningObject(configBeanDefaultValue.getLocation());
            ConfigurationPopulator populator = null;
            if (replaceSystemProperties) {
                try {
                    populator = new ConfigurationPopulator(this.configModularityUtils.replacePropertiesWithCurrentValue(configBeanDefaultValue.getXmlConfiguration(), configBeanDefaultValue), (DomDocument)doc, parent);
                }
                catch (Exception e) {
                    localStrings = new LocalStringManagerImpl(ConfigurationParser.class);
                    msg = localStrings.getLocalString("can.not.add.configuration.to.extension.point", "Cannot add new configuration extension to the extension point.");
                    LOG.log(Level.SEVERE, msg, e);
                }
            } else {
                populator = new ConfigurationPopulator(configBeanDefaultValue.getXmlConfiguration(), (DomDocument)doc, parent);
            }
            populator.run(configParser);
            try {
                Class configBeanClass = this.configModularityUtils.getClassForFullName(configBeanDefaultValue.getConfigBeanClassName());
                ConfigBeanProxy pr = doc.getRoot().createProxy(configBeanClass);
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ConfigBeanProxy>((DomDocument)doc, pr, configBeanDefaultValue){
                    final /* synthetic */ DomDocument val$doc;
                    final /* synthetic */ ConfigBeanProxy val$pr;
                    final /* synthetic */ ConfigBeanDefaultValue val$configBeanDefaultValue;
                    {
                        this.val$doc = domDocument;
                        this.val$pr = configBeanProxy;
                        this.val$configBeanDefaultValue = configBeanDefaultValue;
                    }

                    public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                        boolean writeDefaultElementsToXml = Boolean.parseBoolean(System.getProperty("writeDefaultElementsToXml", "true"));
                        if (!writeDefaultElementsToXml) {
                            this.val$doc.getRoot().skipFromXml();
                        }
                        ConfigurationParser.this.configModularityUtils.setConfigBean(this.val$pr, this.val$configBeanDefaultValue, param);
                        return param;
                    }
                }, (ConfigBeanProxy)parent);
            }
            catch (TransactionFailure e) {
                localStrings = new LocalStringManagerImpl(ConfigurationParser.class);
                msg = localStrings.getLocalString("can.not.add.configuration.to.extension.point", "Cannot add new configuration extension to the extension point.");
                LOG.log(Level.SEVERE, msg, e);
            }
        }
    }
}

