/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.annotation.ActivateOnStartup;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.parser.ConfigurationParser;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(mode=1, value=2)
public class StartupConfigBeanOverrider
implements PostConstruct {
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    StartupContext startupContext;
    @Inject
    private ConfigurationParser configurationParser;
    @Inject
    private ConfigModularityUtils configModularityUtils;
    private static final Logger LOG = Logger.getLogger(StartupConfigBeanOverrider.class.getName());

    public void postConstruct() {
        LOG.info("Starting the config overriding procedure");
        List<Class> configBeans = this.configModularityUtils.getAnnotatedConfigBeans(ActivateOnStartup.class);
        for (Class clz : configBeans) {
            LOG.info("Overriding Config specified by: " + clz.getName());
            this.applyConfigIfNeeded(clz);
        }
        LOG.info("Finished the config overriding procedure");
    }

    private void applyConfigIfNeeded(Class<?> clz) {
        try {
            List<ConfigBeanDefaultValue> configBeanDefaultValueList = this.configModularityUtils.getDefaultConfigurations(clz, this.configModularityUtils.getRuntimeTypePrefix(this.startupContext));
            this.configurationParser.parseAndSetConfigBean(configBeanDefaultValueList);
        }
        catch (Throwable tr) {
            LOG.log(Level.FINER, "Cannot override or load the default configuration", tr);
        }
    }
}

