/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.customvalidators.ConfigRefValidator;
import com.sun.enterprise.config.serverbeans.customvalidators.ReferenceConstraint;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.UnexpectedTypeException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceValidator
implements ConstraintValidator<ReferenceConstraint, ConfigBeanProxy> {
    static final Logger logger = LogDomains.getLogger(ConfigRefValidator.class, (String)"javax.enterprise.system.tools.admin");
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ReferenceValidator.class);
    private ReferenceConstraint rc;

    public void initialize(ReferenceConstraint rc) {
        this.rc = rc;
    }

    public boolean isValid(ConfigBeanProxy config, ConstraintValidatorContext cvc) throws UnexpectedTypeException {
        if (config == null) {
            return true;
        }
        Dom dom = Dom.unwrap((ConfigBeanProxy)config);
        if (this.rc.skipDuringCreation() && dom.getKey() == null) {
            return true;
        }
        Collection<RemoteKeyInfo> remoteKeys = this.findRemoteKeys(config);
        if (remoteKeys != null && !remoteKeys.isEmpty()) {
            Habitat habitat = dom.getHabitat();
            boolean result = true;
            boolean disableGlobalMessage = true;
            for (RemoteKeyInfo remoteKeyInfo : remoteKeys) {
                if (remoteKeyInfo.method.getParameterTypes().length > 0) {
                    throw new UnexpectedTypeException(localStrings.getLocalString("referenceValidator.not.getter", "ReferenceConstraint annotaion must be on getter method only."));
                }
                try {
                    Object value = remoteKeyInfo.method.invoke((Object)config, new Object[0]);
                    if (value instanceof String) {
                        String key = (String)value;
                        ConfigBeanProxy component = (ConfigBeanProxy)habitat.getComponent(remoteKeyInfo.annotation.type(), key);
                        if (component != null) continue;
                        result = false;
                        if (remoteKeyInfo.annotation.message().isEmpty()) {
                            disableGlobalMessage = false;
                            continue;
                        }
                        cvc.buildConstraintViolationWithTemplate(remoteKeyInfo.annotation.message()).addNode(Dom.convertName((String)remoteKeyInfo.method.getName())).addConstraintViolation();
                        continue;
                    }
                    throw new UnexpectedTypeException(localStrings.getLocalString("referenceValidator.not.string", "Remote key must be String."));
                }
                catch (Exception ex) {
                    return false;
                }
            }
            if (!result && disableGlobalMessage) {
                cvc.disableDefaultConstraintViolation();
            }
            return result;
        }
        return true;
    }

    private Collection<RemoteKeyInfo> findRemoteKeys(Object o) {
        ArrayList<RemoteKeyInfo> result = new ArrayList<RemoteKeyInfo>();
        if (o == null) {
            return result;
        }
        this.findRemoteKeys(o.getClass(), result);
        return result;
    }

    private void findRemoteKeys(Class c, Collection<RemoteKeyInfo> result) {
        Class<?>[] interfaces;
        Method[] methods;
        for (Method method : methods = c.getMethods()) {
            ReferenceConstraint.RemoteKey annotation = method.getAnnotation(ReferenceConstraint.RemoteKey.class);
            if (annotation == null) continue;
            result.add(new RemoteKeyInfo(method, c, annotation));
        }
        Class superclass = c.getSuperclass();
        if (superclass != null) {
            this.findRemoteKeys(superclass, result);
        }
        for (Class<?> iface : interfaces = c.getInterfaces()) {
            this.findRemoteKeys(iface, result);
        }
    }

    class RemoteKeyInfo {
        final Method method;
        final Class sourceClass;
        final ReferenceConstraint.RemoteKey annotation;

        public RemoteKeyInfo(Method method, Class sourceClass, ReferenceConstraint.RemoteKey annotation) {
            this.method = method;
            this.sourceClass = sourceClass;
            this.annotation = annotation;
        }
    }
}

