/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.SecureAdminHelper;
import com.sun.enterprise.config.serverbeans.SecureAdminInternalUser;
import com.sun.enterprise.config.serverbeans.SecureAdminPrincipal;
import java.util.Collections;
import java.util.List;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.Delete;
import org.glassfish.config.support.Listing;
import org.glassfish.config.support.TypeAndNameResolver;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface SecureAdmin
extends ConfigBeanProxy,
Injectable {
    @Element
    @Create(value="enable-secure-admin-principal", decorator=SecureAdminPrincipal.CrDecorator.class, i18n=@I18n(value="enable.secure.admin.principal.command"), cluster=@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE}))
    @Delete(value="disable-secure-admin-principal", resolver=SecureAdminPrincipal.Resolver.class, i18n=@I18n(value="disable.secure.admin.principal.command"), cluster=@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE}))
    @Listing(value="list-secure-admin-principals", i18n=@I18n(value="list.secure.admin.principals.command"))
    public List<SecureAdminPrincipal> getSecureAdminPrincipal();

    @Element
    @Create(value="enable-secure-admin-internal-user", decorator=SecureAdminInternalUser.CrDecorator.class, i18n=@I18n(value="enable.secure.admin.internal.user.command"), cluster=@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE}))
    @Delete(value="disable-secure-admin-internal-user", resolver=TypeAndNameResolver.class, i18n=@I18n(value="disable.secure.admin.internal.user.command"), cluster=@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE}))
    @Listing(value="list-secure-admin-internal-users", i18n=@I18n(value="list.secure.admin.internal.user.command"))
    public List<SecureAdminInternalUser> getSecureAdminInternalUser();

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getEnabled();

    public void setEnabled(String var1);

    @Attribute(defaultValue="true")
    public String getSpecialAdminIndicator();

    public void setSpecialAdminIndicator(String var1);

    @Attribute(defaultValue="s1as")
    public String dasAlias();

    public void setDasAlias(String var1);

    @Attribute(defaultValue="glassfish-instance")
    public String instanceAlias();

    public void setInstanceAlias(String var1);

    @DuckTyped
    public String getInstanceAlias();

    @DuckTyped
    public String getDasAlias();

    @DuckTyped
    public boolean isEnabled();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Util {
        public static final String ADMIN_INDICATOR_HEADER_NAME = "X-GlassFish-admin";
        public static final String ADMIN_INDICATOR_DEFAULT_VALUE = "true";
        public static final String ADMIN_ONE_TIME_AUTH_TOKEN_HEADER_NAME = "X-GlassFish-authToken";
        private static volatile SecureAdminHelper _secureAdminHelper = null;

        public static boolean isEnabled(SecureAdmin secureAdmin) {
            return secureAdmin != null && Boolean.parseBoolean(secureAdmin.getEnabled());
        }

        public static String configuredAdminIndicator(SecureAdmin secureAdmin) {
            return secureAdmin == null ? ADMIN_INDICATOR_DEFAULT_VALUE : secureAdmin.getSpecialAdminIndicator();
        }

        public static String DASAlias(SecureAdmin secureAdmin) {
            return secureAdmin == null ? "s1as" : secureAdmin.getDasAlias();
        }

        public static String instanceAlias(SecureAdmin secureAdmin) {
            return secureAdmin == null ? "glassfish-instance" : secureAdmin.getInstanceAlias();
        }

        public static List<SecureAdminInternalUser> secureAdminInternalUsers(SecureAdmin secureAdmin) {
            return secureAdmin == null ? Collections.EMPTY_LIST : secureAdmin.getSecureAdminInternalUser();
        }

        public static SecureAdminInternalUser secureAdminInternalUser(SecureAdmin secureAdmin) {
            List<SecureAdminInternalUser> secureAdminUsers = Util.secureAdminInternalUsers(secureAdmin);
            return secureAdminUsers.isEmpty() ? null : secureAdminUsers.get(0);
        }

        public static boolean isUsingUsernamePasswordAuth(SecureAdmin secureAdmin) {
            return !Util.secureAdminInternalUsers(secureAdmin).isEmpty();
        }

        public static List<SecureAdminPrincipal> secureAdminPrincipals(SecureAdmin secureAdmin, Habitat habitat) {
            List<SecureAdminPrincipal> result = Collections.EMPTY_LIST;
            if (secureAdmin != null && (result = secureAdmin.getSecureAdminPrincipal()).isEmpty()) {
                try {
                    Transaction t = new Transaction();
                    SecureAdmin secureAdmin_w = (SecureAdmin)t.enroll((ConfigBeanProxy)secureAdmin);
                    result = secureAdmin_w.getSecureAdminPrincipal();
                    SecureAdminPrincipal dasPrincipal = (SecureAdminPrincipal)secureAdmin_w.createChild(SecureAdminPrincipal.class);
                    dasPrincipal.setDn(Util.secureAdminHelper(habitat).getDN(secureAdmin.dasAlias(), true));
                    result.add(dasPrincipal);
                    SecureAdminPrincipal instancePrincipal = (SecureAdminPrincipal)secureAdmin_w.createChild(SecureAdminPrincipal.class);
                    instancePrincipal.setDn(Util.secureAdminHelper(habitat).getDN(secureAdmin.instanceAlias(), true));
                    result.add(instancePrincipal);
                    t.commit();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            return result;
        }

        private static synchronized SecureAdminHelper secureAdminHelper(Habitat habitat) {
            if (_secureAdminHelper == null) {
                _secureAdminHelper = (SecureAdminHelper)habitat.getComponent(SecureAdminHelper.class);
            }
            return _secureAdminHelper;
        }
    }

    public static class Duck {
        public static final String DEFAULT_INSTANCE_ALIAS = "glassfish-instance";
        public static final String DEFAULT_ADMIN_ALIAS = "s1as";

        public static String getInstanceAlias(SecureAdmin secureAdmin) {
            return secureAdmin.instanceAlias();
        }

        public static String getDasAlias(SecureAdmin secureAdmin) {
            return secureAdmin.dasAlias();
        }
    }
}

