/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupFilenameManager;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.BackupRestoreManager;
import com.sun.enterprise.backup.Status;
import com.sun.enterprise.backup.StringHelper;
import com.sun.enterprise.backup.util.BackupUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFile;
import java.io.File;
import java.io.IOException;

public class RestoreManager
extends BackupRestoreManager {
    private static final String OLD_DOMAIN_SUFFIX = "_beforeRestore_";
    private File tempRestoreDir;
    private File backupDir;

    public RestoreManager(BackupRequest req) throws BackupException {
        super(req);
    }

    public String restore() throws BackupException {
        try {
            boolean isConfigBackup = this.isAConfigBackup();
            this.checkDomainName();
            ZipFile zf = new ZipFile(this.request.backupFile, this.tempRestoreDir);
            zf.explode();
            this.sanityCheckExplodedFiles();
            if (!isConfigBackup) {
                this.copyBackups();
            }
            this.atomicSwap(this.request.domainDir, this.request.domainName, isConfigBackup);
            this.setPermissions();
            String mesg = this.readAndDeletePropsFile(isConfigBackup);
            return mesg;
        }
        catch (BackupException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BackupException("Restore Error" + e.toString(), e);
        }
    }

    void init() throws BackupException {
        super.init();
        if (this.request.backupFile == null) {
            this.initWithNoSpecifiedBackupFile();
        } else {
            this.initWithSpecifiedBackupFile();
        }
        this.tempRestoreDir = new File(this.request.domainsDir, this.request.domainName + "_" + System.currentTimeMillis());
    }

    private void initWithSpecifiedBackupFile() throws BackupException {
        if (this.request.backupFile.length() <= 0L) {
            throw new BackupException("backup-res.CorruptBackupFile", this.request.backupFile);
        }
        if (this.request.domainName == null) {
            if (!this.request.force) {
                throw new BackupException("backup-res.UseForceOption");
            }
            Status status = new Status();
            status.read(this.request.backupFile);
            this.request.domainName = status.getDomainName();
            this.request.domainDir = new File(this.request.domainsDir, this.request.domainName);
        }
        if (!FileUtils.safeIsDirectory((File)this.request.domainDir) && !this.request.domainDir.mkdirs()) {
            throw new BackupException("backup-res.CantCreateDomainDir", this.request.domainDir);
        }
        this.backupDir = new File(this.request.domainDir, "backups");
        if (!FileUtils.safeIsDirectory((File)this.backupDir)) {
            this.backupDir = null;
        }
    }

    private void initWithNoSpecifiedBackupFile() throws BackupException {
        if (!FileUtils.safeIsDirectory((File)this.request.domainDir)) {
            throw new BackupException("backup-res.NoDomainDir", this.request.domainDir);
        }
        this.backupDir = this.getBackupDirectory(this.request);
        if (!FileUtils.safeIsDirectory((File)this.backupDir)) {
            throw new BackupException("backup-res.NoBackupDir", this.backupDir);
        }
        BackupFilenameManager bfmgr = new BackupFilenameManager(this.backupDir, this.request.domainName);
        this.request.backupFile = bfmgr.latest();
    }

    private void copyBackups() throws IOException {
        File domainBackupDir = new File(this.request.domainDir, "backups");
        if (!FileUtils.safeIsDirectory((File)domainBackupDir)) {
            return;
        }
        File tempRestoreDirBackups = new File(this.tempRestoreDir, "backups");
        FileUtils.copyTree((File)domainBackupDir, (File)tempRestoreDirBackups);
    }

    private void atomicSwap(File domainDir, String domainName, boolean configOnly) throws BackupException {
        File configDir = new File(this.request.domainsDir, domainName + "/" + "config");
        File oldDir = configOnly ? new File(this.request.domainsDir, domainName + "/" + "config" + OLD_DOMAIN_SUFFIX + System.currentTimeMillis()) : new File(this.request.domainsDir, domainName + OLD_DOMAIN_SUFFIX + System.currentTimeMillis());
        if (configOnly) {
            if (!configDir.renameTo(oldDir)) {
                FileUtils.whack((File)this.tempRestoreDir);
                throw new BackupException("backup-res.CantRenameOriginalDomain", configDir);
            }
        } else if (!domainDir.renameTo(oldDir)) {
            FileUtils.whack((File)this.tempRestoreDir);
            throw new BackupException("backup-res.CantRenameOriginalDomain", domainDir);
        }
        if (configOnly) {
            if (!this.tempRestoreDir.renameTo(configDir)) {
                FileUtils.whack((File)this.tempRestoreDir);
                if (!oldDir.renameTo(configDir)) {
                    throw new BackupException("backup-res.CantRevertOldDomain", configDir);
                }
                throw new BackupException("backup-res.CantRenameRestoredDomain");
            }
        } else if (!this.tempRestoreDir.renameTo(domainDir)) {
            FileUtils.whack((File)this.tempRestoreDir);
            if (!oldDir.renameTo(domainDir)) {
                throw new BackupException("backup-res.CantRevertOldDomain", domainDir);
            }
            throw new BackupException("backup-res.CantRenameRestoredDomain");
        }
        FileUtils.whack((File)oldDir);
    }

    private String readAndDeletePropsFile(boolean isConfigBackup) {
        String mesg = "";
        File propsFile = isConfigBackup ? new File(this.request.domainDir, "config/backup.properties") : new File(this.request.domainDir, "backup.properties");
        if (this.request.verbose || !this.request.terse) {
            mesg = isConfigBackup ? StringHelper.get("backup-res.SuccessfulConfigRestore", this.request.domainName, this.request.domainDir) : StringHelper.get("backup-res.SuccessfulFullRestore", this.request.domainName, this.request.domainDir);
        }
        if (this.request.verbose) {
            Status status = new Status();
            mesg = mesg + "\n" + status.read(propsFile, false);
        }
        if (!propsFile.delete()) {
            propsFile.deleteOnExit();
        }
        return mesg;
    }

    private void setPermissions() {
        File backups = new File(this.request.domainDir, "backups");
        File bin = new File(this.request.domainDir, "bin");
        File config = new File(this.request.domainDir, "config");
        File webtmp = new File(this.request.domainDir, "generated/tmp");
        File masterPassword = new File(this.request.domainDir, "master-password");
        BackupUtils.makeExecutable(bin);
        BackupUtils.protect(backups);
        BackupUtils.protect(config);
        BackupUtils.protect(masterPassword);
        BackupUtils.protect(webtmp);
    }

    private void sanityCheckExplodedFiles() throws BackupException {
        File statusFile = new File(this.tempRestoreDir, "backup.properties");
        if (!statusFile.exists()) {
            FileUtils.whack((File)this.tempRestoreDir);
            throw new BackupException("backup-res.RestoreError.CorruptBackupFile.NoStatusFile", this.request.domainName);
        }
    }

    private void checkDomainName() throws BackupException {
        Status status = new Status();
        status.read(this.request.backupFile);
        String buDomainName = status.getDomainName();
        if (buDomainName == null) {
            throw new BackupException(StringHelper.get("backup-res.CorruptBackupFile", this.request.backupFile));
        }
        if (!this.request.domainName.equals(buDomainName) && !this.request.force) {
            throw new BackupException(StringHelper.get("backup-res.DomainNameDifferentWarning", buDomainName, this.request.domainName));
        }
    }

    private boolean isAConfigBackup() {
        Status status = new Status();
        status.read(this.request.backupFile);
        String backupType = status.getBackupType();
        if (backupType == null || backupType.equals("")) {
            return false;
        }
        return !backupType.equals("full");
    }
}

