/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupWarningException;
import com.sun.enterprise.backup.Status;
import com.sun.enterprise.backup.ZipFilenameFilter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BackupFilenameManager {
    private final File dir;
    private final String domainName;
    private String desc;
    private final SortedMap<Integer, ZipFileAndNumber> zipFiles = new TreeMap<Integer, ZipFileAndNumber>();

    BackupFilenameManager(File backupDir, String domainName) throws BackupException {
        this.dir = backupDir;
        this.domainName = domainName;
        this.findZips();
    }

    File next() throws BackupException {
        ZipFileAndNumber latest;
        int newVersionNum = 1;
        ZipFileAndNumber zipFileAndNumber = latest = this.zipFiles.isEmpty() ? null : (ZipFileAndNumber)this.zipFiles.get(this.zipFiles.lastKey());
        if (latest != null) {
            newVersionNum = latest.num + 1;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy_MM_dd");
        Date date = new Date();
        String fname = this.domainName + "_" + formatter.format(date) + "_v";
        String suffix = this.padWithLeadingZeroes(newVersionNum);
        this.desc = this.domainName + " backup created on " + formatter.format(date) + " by user " + System.getProperty("user.name");
        return new File(this.dir, fname + suffix + ".zip");
    }

    File latest() throws BackupWarningException {
        if (this.zipFiles.isEmpty()) {
            throw new BackupWarningException("backup-res.NoBackupFiles", this.dir);
        }
        return ((ZipFileAndNumber)this.zipFiles.get(this.zipFiles.lastKey())).zip;
    }

    List<File> getRecycleFiles(int limit) {
        ArrayList<File> files = new ArrayList<File>();
        if (limit > 0) {
            int recycleCount = this.zipFiles.size() > limit ? this.zipFiles.size() - limit : 0;
            Iterator<ZipFileAndNumber> it = this.zipFiles.values().iterator();
            for (int i = 0; i < recycleCount; ++i) {
                files.add(it.next().zip);
            }
        }
        return files;
    }

    private void findZips() {
        File[] zips = this.dir.listFiles(new ZipFilenameFilter());
        for (int i = 0; zips != null && i < zips.length; ++i) {
            ZipFileAndNumber zfan = new ZipFileAndNumber(zips[i]);
            this.zipFiles.put(zfan.num, zfan);
        }
    }

    private String padWithLeadingZeroes(int num) throws BackupException {
        if (num < 10) {
            return "0000" + num;
        }
        if (num < 100) {
            return "000" + num;
        }
        if (num < 1000) {
            return "00" + num;
        }
        if (num < 10000) {
            return "0" + num;
        }
        if (num < 100000) {
            return "" + num;
        }
        throw new BackupException("Latest version >= 100,000.  Delete some backup files.");
    }

    public String getCustomizedDescription() {
        return this.desc;
    }

    public static void main(String[] args) {
        try {
            File f = new File(args[0]);
            BackupFilenameManager mgr = new BackupFilenameManager(f, "foo");
            File fnew = mgr.next();
            System.out.println("Next backup file: " + fnew);
            File fold = mgr.latest();
            System.out.println("Latest backup file: " + fold);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ZipFileAndNumber {
        private File zip;
        private int num = -1;

        private ZipFileAndNumber(File zip) {
            this.zip = zip;
            String fname = zip.getName();
            if (this.isValid()) {
                fname = fname.substring(fname.lastIndexOf("_v") + 2, fname.length() - 4);
                try {
                    this.num = Integer.parseInt(fname);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private boolean isValid() {
            Status status = new Status();
            long time = status.getInternalTimestamp(this.zip);
            return time > 0L;
        }
    }
}

