/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

public final class CLIConstants {
    public static final int DEFAULT_ADMIN_PORT = 4848;
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String EOL = System.lineSeparator();
    public static final long WAIT_FOR_DAS_TIME_MS = CLIConstants.getEnv("AS_START_TIMEOUT", 60000L);
    public static final int RESTART_NORMAL = 10;
    public static final int RESTART_DEBUG_ON = 11;
    public static final int RESTART_DEBUG_OFF = 12;
    public static final String WALL_CLOCK_START_PROP = "WALL_CLOCK_START";
    public static final String MASTER_PASSWORD = "AS_ADMIN_MASTERPASSWORD";
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 4;
    public static final long DEATH_TIMEOUT_MS = CLIConstants.getEnv("AS_STOP_TIMEOUT", 60000L);
    public static final String K_ADMIN_PORT = "agent.adminPort";
    public static final String K_ADMIN_HOST = "agent.adminHost";
    public static final String K_AGENT_PROTOCOL = "agent.protocol";
    public static final String K_CLIENT_HOST = "agent.client.host";
    public static final String K_DAS_HOST = "agent.das.host";
    public static final String K_DAS_PROTOCOL = "agent.das.protocol";
    public static final String K_DAS_PORT = "agent.das.port";
    public static final String K_DAS_IS_SECURE = "agent.das.isSecure";
    public static final String K_MASTER_PASSWORD = "agent.masterpassword";
    public static final String K_SAVE_MASTER_PASSWORD = "agent.saveMasterPassword";
    public static final String AGENT_LISTEN_ADDRESS_NAME = "listenaddress";
    public static final String REMOTE_CLIENT_ADDRESS_NAME = "remoteclientaddress";
    public static final String AGENT_JMX_PROTOCOL_NAME = "agentjmxprotocol";
    public static final String DAS_JMX_PROTOCOL_NAME = "dasjmxprotocol";
    public static final String AGENT_DAS_IS_SECURE = "isDASSecure";
    public static final String NODEAGENT_DEFAULT_DAS_IS_SECURE = "false";
    public static final String NODEAGENT_DEFAULT_DAS_PORT = String.valueOf(4848);
    public static final String NODEAGENT_DEFAULT_HOST_ADDRESS = "0.0.0.0";
    public static final String NODEAGENT_JMX_DEFAULT_PROTOCOL = "rmi_jrmp";
    public static final String HOST_NAME_PROPERTY = "com.sun.aas.hostName";
    public static final int RESTART_CHECK_INTERVAL_MSEC = 10;

    private CLIConstants() {
    }

    private static long getEnv(String name, long defaultValue) {
        String value = System.getenv(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            long parsedValue = Long.parseLong(value);
            if (parsedValue > 0L) {
                return parsedValue;
            }
            System.getLogger(CLIConstants.class.getName()).log(System.Logger.Level.WARNING, "The value of the environment property {0} must be positive.", name);
            return defaultValue;
        }
        catch (NumberFormatException e) {
            System.getLogger(CLIConstants.class.getName()).log(System.Logger.Level.WARNING, "Environment property {0} is set to a value {1} which cannot be parsed to long.", name, value);
            return defaultValue;
        }
    }
}

