/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jsondemos.jsonpointer;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;

public class JsonpointerDemo {
    public static void main(String ... args) throws Exception {
        JsonpointerDemo.testWiki();
        JsonpointerDemo.testPointer();
    }

    private static void testWiki() throws IOException {
        try (InputStream is = JsonpointerDemo.class.getResourceAsStream("/wiki.json");
             JsonReader rdr = Json.createReader((InputStream)is);){
            JsonObject person = rdr.readObject();
            JsonpointerDemo.assertEquals("NY", JsonpointerDemo.getString((JsonValue)person, "/address/state"));
            JsonpointerDemo.assertEquals("212 555-1234", JsonpointerDemo.getString((JsonValue)person, "/phoneNumber/0/number"));
        }
    }

    private static void testPointer() throws IOException {
        try (InputStream is = JsonpointerDemo.class.getResourceAsStream("/jsonpointer.json");
             JsonReader rdr = Json.createReader((InputStream)is);){
            JsonObject root = rdr.readObject();
            JsonpointerDemo.assertEquals((JsonValue)root, JsonpointerDemo.get((JsonValue)root, ""));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"foo"), JsonpointerDemo.get((JsonValue)root, "/foo"));
            JsonpointerDemo.assertEquals((JsonValue)root.getJsonArray("foo").get(0), JsonpointerDemo.get((JsonValue)root, "/foo/0"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)""), JsonpointerDemo.get((JsonValue)root, "/"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"a/b"), JsonpointerDemo.get((JsonValue)root, "/a~1b"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"c%d"), JsonpointerDemo.get((JsonValue)root, "/c%d"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"e^f"), JsonpointerDemo.get((JsonValue)root, "/e^f"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"k\"l"), JsonpointerDemo.get((JsonValue)root, "/k\"l"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"i\\j"), JsonpointerDemo.get((JsonValue)root, "/i\\j"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)" "), JsonpointerDemo.get((JsonValue)root, "/ "));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"m~n"), JsonpointerDemo.get((JsonValue)root, "/m~0n"));
            JsonObject doc = Json.createObjectBuilder().add("doc", (JsonValue)root).build();
            root = doc.getJsonObject("doc");
            JsonpointerDemo.assertEquals((JsonValue)doc, JsonpointerDemo.get((JsonValue)doc, ""));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"foo"), JsonpointerDemo.get((JsonValue)doc, "/doc/foo"));
            JsonpointerDemo.assertEquals((JsonValue)root.getJsonArray("foo").get(0), JsonpointerDemo.get((JsonValue)doc, "/doc/foo/0"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)""), JsonpointerDemo.get((JsonValue)doc, "/doc/"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"a/b"), JsonpointerDemo.get((JsonValue)doc, "/doc/a~1b"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"c%d"), JsonpointerDemo.get((JsonValue)doc, "/doc/c%d"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"e^f"), JsonpointerDemo.get((JsonValue)doc, "/doc/e^f"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"k\"l"), JsonpointerDemo.get((JsonValue)doc, "/doc/k\"l"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"i\\j"), JsonpointerDemo.get((JsonValue)doc, "/doc/i\\j"));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)" "), JsonpointerDemo.get((JsonValue)doc, "/doc/ "));
            JsonpointerDemo.assertEquals((JsonValue)root.get((Object)"m~n"), JsonpointerDemo.get((JsonValue)doc, "/doc/m~0n"));
        }
    }

    private static String getString(JsonValue root, String pointer) {
        return ((JsonString)JsonpointerDemo.get(root, pointer)).getString();
    }

    private static JsonValue get(JsonValue root, String pointer) {
        if (pointer.isEmpty()) {
            return root;
        }
        if (pointer.charAt(0) != '/') {
            throw new IllegalArgumentException("JsonPointer " + pointer + " doesn't start with /");
        }
        StringBuilder referenceToken = new StringBuilder();
        for (int i = 1; i < pointer.length(); ++i) {
            char ch = pointer.charAt(i);
            if (ch == '/') {
                return JsonpointerDemo.get(JsonpointerDemo.newRoot(root, referenceToken.toString()), pointer.substring(i));
            }
            if (ch == '~') {
                if (i + 1 == pointer.length()) {
                    throw new IllegalArgumentException("Illegal escaping: expected ~0 or ~1, but got only ~ in pointer=" + pointer);
                }
                if ((ch = pointer.charAt(++i)) == '0') {
                    referenceToken.append('~');
                    continue;
                }
                if (ch == '1') {
                    referenceToken.append('/');
                    continue;
                }
                throw new IllegalArgumentException("Illegal escaping: expected ~0 or ~1, but got ~" + ch + " in pointer=" + pointer);
            }
            referenceToken.append(ch);
        }
        return JsonpointerDemo.newRoot(root, referenceToken.toString());
    }

    private static JsonValue newRoot(JsonValue root, String referenceToken) {
        if (root instanceof JsonObject) {
            return (JsonValue)((JsonObject)root).get((Object)referenceToken);
        }
        if (root instanceof JsonArray) {
            return (JsonValue)((JsonArray)root).get(Integer.parseInt(referenceToken));
        }
        throw new IllegalArgumentException("Illegal reference token=" + referenceToken + " for value=" + root);
    }

    private static void assertEquals(JsonValue exp, JsonValue got) {
        if (exp != got) {
            throw new RuntimeException("Expected = " + exp + " but got = " + got);
        }
    }

    private static void assertEquals(String exp, String got) {
        if (!exp.equals(got)) {
            throw new RuntimeException("Expected = " + exp + " but got = " + got);
        }
    }
}

