/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.oauth2;

import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Feature;
import org.glassfish.jersey.client.oauth2.ClientIdentifier;
import org.glassfish.jersey.client.oauth2.TokenResult;

public interface OAuth2CodeGrantFlow {
    public String start();

    public TokenResult finish(String var1, String var2);

    public TokenResult refreshAccessToken(String var1);

    public Client getAuthorizedClient();

    public Feature getOAuth2Feature();

    public static interface Builder<T extends Builder> {
        public T accessTokenUri(String var1);

        public T authorizationUri(String var1);

        public T redirectUri(String var1);

        public T clientIdentifier(ClientIdentifier var1);

        public T scope(String var1);

        public T client(Client var1);

        public T refreshTokenUri(String var1);

        public T property(Phase var1, String var2, String var3);

        public OAuth2CodeGrantFlow build();
    }

    public static enum Phase {
        AUTHORIZATION{

            @Override
            public void property(String key, String value, Map<String, String> authorizationProps, Map<String, String> accessTokenProps, Map<String, String> refreshTokenProps) {
                Phase.nonNullProperty(key, value, authorizationProps);
            }
        }
        ,
        ACCESS_TOKEN_REQUEST{

            @Override
            public void property(String key, String value, Map<String, String> authorizationProps, Map<String, String> accessTokenProps, Map<String, String> refreshTokenProps) {
                Phase.nonNullProperty(key, value, accessTokenProps);
            }
        }
        ,
        REFRESH_ACCESS_TOKEN{

            @Override
            public void property(String key, String value, Map<String, String> authorizationProps, Map<String, String> accessTokenProps, Map<String, String> refreshTokenProps) {
                Phase.nonNullProperty(key, value, refreshTokenProps);
            }
        }
        ,
        ALL{

            @Override
            public void property(String key, String value, Map<String, String> authorizationProps, Map<String, String> accessTokenProps, Map<String, String> refreshTokenProps) {
                Phase.nonNullProperty(key, value, authorizationProps);
                Phase.nonNullProperty(key, value, accessTokenProps);
                Phase.nonNullProperty(key, value, refreshTokenProps);
            }
        };


        public abstract void property(String var1, String var2, Map<String, String> var3, Map<String, String> var4, Map<String, String> var5);

        private static void nonNullProperty(String key, String value, Map<String, String> props) {
            if (value == null) {
                props.remove(key);
            } else {
                props.put(key, value);
            }
        }
    }
}

