/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.oauth1;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;

public class OAuth1Exception
extends WebApplicationException {
    public OAuth1Exception(Response.Status status, String wwwAuthHeader) {
        super(OAuth1Exception.createResponse(status, wwwAuthHeader));
    }

    public Response.Status getStatus() {
        return Response.Status.fromStatusCode((int)super.getResponse().getStatus());
    }

    public String getWwwAuthHeader() {
        return super.getResponse().getHeaderString("WWW-Authenticate");
    }

    private static Response createResponse(Response.Status status, String wwwAuthHeader) {
        Response.ResponseBuilder rb = Response.status((Response.Status)status);
        if (wwwAuthHeader != null) {
            rb.header("WWW-Authenticate", (Object)wwwAuthHeader);
        }
        return rb.build();
    }
}

