/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.oauth1.internal;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.oauth1.signature.OAuth1Parameters;
import org.glassfish.jersey.oauth1.signature.OAuth1Request;
import org.glassfish.jersey.oauth1.signature.OAuth1Secrets;
import org.glassfish.jersey.oauth1.signature.OAuth1Signature;
import org.glassfish.jersey.oauth1.signature.OAuth1SignatureException;
import org.glassfish.jersey.server.oauth1.OAuth1Consumer;
import org.glassfish.jersey.server.oauth1.OAuth1Exception;
import org.glassfish.jersey.server.oauth1.OAuth1Provider;
import org.glassfish.jersey.server.oauth1.OAuth1Token;
import org.glassfish.jersey.server.oauth1.TokenResource;
import org.glassfish.jersey.server.oauth1.internal.OAuthServerRequest;

@Path(value="/requestToken")
public class RequestTokenResource {
    @Inject
    private OAuth1Provider provider;
    @Inject
    private ContainerRequestContext requestContext;
    @Inject
    private OAuth1Signature oAuth1Signature;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/x-www-form-urlencoded"})
    @TokenResource
    public Response postReqTokenRequest() {
        OAuthServerRequest request = new OAuthServerRequest(this.requestContext);
        OAuth1Parameters params = new OAuth1Parameters();
        params.readRequest((OAuth1Request)request);
        String tok = params.getToken();
        if (tok != null && !tok.contentEquals("")) {
            throw new OAuth1Exception(Response.Status.BAD_REQUEST, null);
        }
        String consKey = params.getConsumerKey();
        if (consKey == null) {
            throw new OAuth1Exception(Response.Status.BAD_REQUEST, null);
        }
        OAuth1Consumer consumer = this.provider.getConsumer(consKey);
        if (consumer == null) {
            throw new OAuth1Exception(Response.Status.BAD_REQUEST, null);
        }
        OAuth1Secrets secrets = new OAuth1Secrets().consumerSecret(consumer.getSecret()).tokenSecret("");
        boolean sigIsOk = false;
        try {
            sigIsOk = this.oAuth1Signature.verify((OAuth1Request)request, params, secrets);
        }
        catch (OAuth1SignatureException ex) {
            Logger.getLogger(RequestTokenResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!sigIsOk) {
            throw new OAuth1Exception(Response.Status.BAD_REQUEST, null);
        }
        MultivaluedHashMap parameters = new MultivaluedHashMap();
        for (String n : request.getParameterNames()) {
            parameters.put((Object)n, request.getParameterValues(n));
        }
        OAuth1Token rt = this.provider.newRequestToken(consKey, params.getCallback(), (Map<String, List<String>>)parameters);
        Form resp = new Form();
        resp.param("oauth_token", rt.getToken());
        resp.param("oauth_token_secret", rt.getSecret());
        resp.param("oauth_callback_confirmed", "true");
        return Response.ok((Object)resp).build();
    }
}

