/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.htmljson;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import net.java.html.json.Context;
import net.java.html.json.Models;
import org.apidesign.html.json.spi.ContextBuilder;
import org.apidesign.html.json.spi.ContextProvider;
import org.apidesign.html.json.spi.JSONCall;
import org.apidesign.html.json.spi.Transfer;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class HtmlJsonProvider
implements MessageBodyWriter,
MessageBodyReader<Object>,
ContextProvider,
Transfer {
    private static final Logger LOG = Logger.getLogger(HtmlJsonProvider.class.getName());
    private static final Context CONTEXT;

    public boolean isWriteable(Class type, Type type1, Annotation[] antns, MediaType mt) {
        if (!mt.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return false;
        }
        return Models.isModel((Class)type);
    }

    public long getSize(Object t, Class type, Type type1, Annotation[] antns, MediaType mt) {
        return -1L;
    }

    public void writeTo(Object t, Class type, Type type1, Annotation[] antns, MediaType mt, MultivaluedMap mm, OutputStream out) throws IOException, WebApplicationException {
        out.write(t.toString().getBytes("UTF-8"));
    }

    public boolean isReadable(Class<?> type, Type type1, Annotation[] antns, MediaType mt) {
        return this.isWriteable(type, type1, antns, mt);
    }

    public Object readFrom(Class<Object> type, Type type1, Annotation[] antns, MediaType mt, MultivaluedMap<String, String> mm, InputStream in) throws IOException, WebApplicationException {
        return Models.parse((Context)CONTEXT, type, (InputStream)in);
    }

    public Context findContext(Class<?> requestor) {
        return CONTEXT;
    }

    public void extract(Object jsonObject, String[] props, Object[] values) {
        if (jsonObject instanceof JSONObject) {
            JSONObject obj = (JSONObject)jsonObject;
            for (int i = 0; i < props.length; ++i) {
                try {
                    values[i] = obj.has(props[i]) ? obj.get(props[i]) : null;
                    continue;
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, "Can't read " + props[i] + " from " + jsonObject, ex);
                }
            }
        }
    }

    public Object toJSON(InputStream is) throws IOException {
        try {
            InputStreamReader r = new InputStreamReader(is, "UTF-8");
            JSONTokener t = new JSONTokener((Reader)r);
            return new JSONObject(t);
        }
        catch (JSONException ex) {
            throw new IOException(ex);
        }
    }

    public void loadJSON(JSONCall call) {
        throw new UnsupportedOperationException();
    }

    static {
        HtmlJsonProvider w = new HtmlJsonProvider();
        CONTEXT = ContextBuilder.create().withTransfer((Transfer)w).build();
    }
}

