/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import java.util.HashMap;
import java.util.Map;

class ResponseContextResolver
extends ELResolver {
    private Map<String, Object> responseObjects = new HashMap<String, Object>();
    private static final String ENTITY_OBJECT = "entity";
    private static final String RESOURCE_OBJECT = "resource";
    static final String INSTANCE_OBJECT = "instance";

    ResponseContextResolver(Object entity, Object resource, Object instance) {
        this.responseObjects.put(ENTITY_OBJECT, entity);
        this.responseObjects.put(RESOURCE_OBJECT, resource);
        this.responseObjects.put(INSTANCE_OBJECT, instance);
    }

    private boolean isHandled(ELContext elc, Object base, Object property) {
        if (base != null) {
            return false;
        }
        if (this.responseObjects.containsKey(property.toString())) {
            elc.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public Object getValue(ELContext elc, Object base, Object property) {
        if (this.isHandled(elc, base, property)) {
            return this.responseObjects.get(property.toString());
        }
        return null;
    }

    public Class<?> getType(ELContext elc, Object o, Object o1) {
        if (this.isHandled(elc, o, o1)) {
            return this.getValue(elc, o, o1).getClass();
        }
        return null;
    }

    public void setValue(ELContext elc, Object o, Object o1, Object o2) {
        throw new PropertyNotWritableException(o2.toString());
    }

    public boolean isReadOnly(ELContext elc, Object o, Object o1) {
        return this.isHandled(elc, o, o1);
    }

    public Class<?> getCommonPropertyType(ELContext elc, Object o) {
        return Object.class;
    }
}

