/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import javax.ws.rs.core.Link;
import org.glassfish.jersey.Beta;
import org.glassfish.jersey.linking.Binding;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.ProvideLinks;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Repeatable(value=ProvideLinks.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Beta
public @interface ProvideLink {
    public InjectLink.Style style() default InjectLink.Style.ABSOLUTE_PATH;

    public Class<?>[] value();

    public Binding[] bindings() default {};

    public String condition() default "";

    public String rel() default "";

    public String rev() default "";

    public String type() default "";

    public String title() default "";

    public String anchor() default "";

    public String media() default "";

    public String hreflang() default "";

    public InjectLink.Extension[] extensions() default {};

    public static interface InheritFromAnnotation {
    }

    public static class Util {
        static Link buildLinkFromUri(URI uri, ProvideLink link) {
            Link.Builder builder = Link.fromUri((URI)uri);
            if (!link.rel().isEmpty()) {
                builder = builder.rel(link.rel());
            }
            if (!link.rev().isEmpty()) {
                builder = builder.param("rev", link.rev());
            }
            if (!link.type().isEmpty()) {
                builder = builder.type(link.type());
            }
            if (!link.title().isEmpty()) {
                builder = builder.param("title", link.title());
            }
            if (!link.anchor().isEmpty()) {
                builder = builder.param("anchor", link.anchor());
            }
            if (!link.media().isEmpty()) {
                builder = builder.param("media", link.media());
            }
            if (!link.hreflang().isEmpty()) {
                builder = builder.param("hreflang", link.hreflang());
            }
            for (InjectLink.Extension ext : link.extensions()) {
                builder = builder.param(ext.name(), ext.value());
            }
            return builder.build(new Object[0]);
        }
    }
}

