/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Link;
import org.glassfish.jersey.linking.FieldDescriptor;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.InjectLinkFieldDescriptor;
import org.glassfish.jersey.linking.InjectLinks;
import org.glassfish.jersey.linking.InjectLinksFieldDescriptor;
import org.glassfish.jersey.linking.LinkHeaderDescriptor;

class EntityDescriptor {
    private static final Map<Class<?>, EntityDescriptor> descriptors = new HashMap();
    private Map<String, FieldDescriptor> nonLinkFields;
    private Map<String, FieldDescriptor> linkFields;
    private List<LinkHeaderDescriptor> linkHeaders = new ArrayList<LinkHeaderDescriptor>();

    static synchronized EntityDescriptor getInstance(Class<?> entityClass) {
        if (descriptors.containsKey(entityClass)) {
            return descriptors.get(entityClass);
        }
        EntityDescriptor descriptor = new EntityDescriptor(entityClass);
        descriptors.put(entityClass, descriptor);
        return descriptor;
    }

    private EntityDescriptor(Class<?> entityClass) {
        this.findLinkHeaders(entityClass);
        this.linkHeaders = Collections.unmodifiableList(this.linkHeaders);
        this.nonLinkFields = new HashMap<String, FieldDescriptor>();
        this.linkFields = new HashMap<String, FieldDescriptor>();
        this.findFields(entityClass);
        this.nonLinkFields = Collections.unmodifiableMap(this.nonLinkFields);
        this.linkFields = Collections.unmodifiableMap(this.linkFields);
    }

    Collection<FieldDescriptor> getLinkFields() {
        return this.linkFields.values();
    }

    Collection<FieldDescriptor> getNonLinkFields() {
        return this.nonLinkFields.values();
    }

    List<LinkHeaderDescriptor> getLinkHeaders() {
        return this.linkHeaders;
    }

    private void findFields(Class<?> entityClass) {
        for (Field f : entityClass.getDeclaredFields()) {
            InjectLink a = f.getAnnotation(InjectLink.class);
            Class<?> t = f.getType();
            if (a != null) {
                if (!t.equals(String.class) && !t.equals(URI.class) && !Link.class.isAssignableFrom(t) || this.linkFields.containsKey(f.getName())) continue;
                this.linkFields.put(f.getName(), new InjectLinkFieldDescriptor(f, a, t));
                continue;
            }
            if (f.isAnnotationPresent(InjectLinks.class)) {
                if (List.class.isAssignableFrom(t) || t.isArray() && Link.class.isAssignableFrom(t.getComponentType())) {
                    InjectLinks a2 = f.getAnnotation(InjectLinks.class);
                    this.linkFields.put(f.getName(), new InjectLinksFieldDescriptor(f, a2, t));
                    continue;
                }
                throw new IllegalArgumentException("Can only inject links onto a List<Link> or Link[] object");
            }
            if ((f.getModifiers() & 8) > 0 || f.getName().startsWith("java.") || f.getName().startsWith("javax.")) continue;
            this.nonLinkFields.put(f.getName(), new FieldDescriptor(f));
        }
        Class<?> sc = entityClass.getSuperclass();
        if (sc != null && sc != Object.class) {
            this.findFields(sc);
        }
        for (Class<?> ic : entityClass.getInterfaces()) {
            this.findFields(ic);
        }
    }

    private void findLinkHeaders(Class<?> entityClass) {
        Class<?> sc;
        InjectLinks linkHeadersAnnotation;
        InjectLink linkHeaderAnnotation = entityClass.getAnnotation(InjectLink.class);
        if (linkHeaderAnnotation != null) {
            this.linkHeaders.add(new LinkHeaderDescriptor(linkHeaderAnnotation));
        }
        if ((linkHeadersAnnotation = entityClass.getAnnotation(InjectLinks.class)) != null) {
            for (InjectLink linkHeader : linkHeadersAnnotation.value()) {
                this.linkHeaders.add(new LinkHeaderDescriptor(linkHeader));
            }
        }
        if ((sc = entityClass.getSuperclass()) != null && sc != Object.class) {
            this.findLinkHeaders(sc);
        }
        for (Class<?> ic : entityClass.getInterfaces()) {
            this.findLinkHeaders(ic);
        }
    }
}

