/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.xmlmoxy;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.glassfish.jersey.examples.xmlmoxy.beans.Address;
import org.glassfish.jersey.examples.xmlmoxy.beans.Customer;
import org.glassfish.jersey.examples.xmlmoxy.beans.PhoneNumber;

@Path(value="/customer")
public class CustomerResource {
    private static Customer customer = CustomerResource.createInitialCustomer();

    @GET
    @Produces(value={"application/xml"})
    public Customer getCustomer() {
        return customer;
    }

    @PUT
    @Consumes(value={"application/xml"})
    public void setCustomer(Customer c) {
        CustomerResource.setCustomerToStatic(c);
    }

    private static Customer createInitialCustomer() {
        Customer result = new Customer();
        result.setName("Jane Doe");
        result.setAddress(new Address("123 Any Street", "My Town"));
        result.getPhoneNumbers().add(new PhoneNumber("work", "613-555-1111"));
        result.getPhoneNumbers().add(new PhoneNumber("cell", "613-555-2222"));
        return result;
    }

    private static void setCustomerToStatic(Customer customer) {
        CustomerResource.customer = customer;
    }
}

