/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.xmlmoxy;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.glassfish.jersey.examples.xmlmoxy.beans.Address;
import org.glassfish.jersey.examples.xmlmoxy.beans.Customer;
import org.glassfish.jersey.examples.xmlmoxy.beans.PhoneNumber;

@Path(value="/customer")
public class CustomerResource {
    private static Customer customer = CustomerResource.createInitialCustomer();

    @GET
    @Produces(value={"application/xml"})
    public Customer getCustomer() {
        return customer;
    }

    @PUT
    @Consumes(value={"application/xml"})
    public void setCustomer(Customer c) {
        CustomerResource.setCustomerToStatic(c);
    }

    private static Customer createInitialCustomer() {
        Customer result = new Customer();
        result.setName("Jane Doe");
        result.setAddress(new Address("123 Any Street", "My Town"));
        result.getPhoneNumbers().add(new PhoneNumber("work", "613-555-1111"));
        result.getPhoneNumbers().add(new PhoneNumber("cell", "613-555-2222"));
        return result;
    }

    private static void setCustomerToStatic(Customer customer) {
        CustomerResource.customer = customer;
    }
}

