/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.console;

import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class App {
    public static final URI BASE_URI = App.getBaseURI();
    public static final int defaultPort = 9998;

    private static int getPort(int defaultPort) {
        String port = System.getProperty("jersey.config.test.container.port");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                System.out.println("Value of jersey.config.test.container.port property is not a valid positive integer [" + port + "]. Reverting to default [" + defaultPort + "].");
            }
        }
        return defaultPort;
    }

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/resources").port(App.getPort(9998)).build(new Object[0]);
    }

    public static ResourceConfig createApp() {
        return new ResourceConfig().register((Object)new JettisonFeature()).packages(new String[]{"org.glassfish.jersey.examples.console"});
    }

    public static void main(String[] args) {
        try {
            System.out.println("Simple Console Jersey Example App");
            final HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)App.getBaseURI(), (ResourceConfig)App.createApp(), (boolean)false);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    server.shutdownNow();
                }
            }));
            server.start();
            System.out.println(String.format("Application started.%nTry out %s%nStop the application using CTRL+C", String.valueOf(BASE_URI) + "/form"));
            Thread.currentThread().join();
        }
        catch (IOException | InterruptedException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

