/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.console.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;

public class Colours {
    private static String[] colours = new String[]{"red", "orange", "yellow", "green", "blue", "indigo", "violet"};

    @GET
    @Produces(value={"text/plain"})
    public String getColourListAsText(@QueryParam(value="match") String filter) {
        StringBuilder buf = new StringBuilder();
        for (String colour : Colours.getMatchingColours(filter)) {
            buf.append(colour);
            buf.append('\n');
        }
        return buf.toString();
    }

    @GET
    @Produces(value={"application/json"})
    public JSONArray getColourListAsJSON(@QueryParam(value="match") String filter) {
        return new JSONArray(Colours.getMatchingColours(filter));
    }

    public static List<String> getMatchingColours(String filter) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String colour : colours) {
            if (filter != null && filter.length() != 0 && !colour.contains(filter)) continue;
            matches.add(colour);
        }
        return matches;
    }
}

