/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.glassfish.jersey.internal.guava.ThreadFactoryBuilder;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;

@Path(value="async/longrunning")
@Produces(value={"text/plain"})
public class SimpleLongRunningResource {
    public static final String NOTIFICATION_RESPONSE = "Hello async world!";
    private static final Logger LOGGER = Logger.getLogger(SimpleLongRunningResource.class.getName());
    private static final int SLEEP_TIME_IN_MILLIS = 1000;
    private static final ExecutorService TASK_EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("long-running-resource-executor-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JerseyProcessingUncaughtExceptionHandler()).build());

    @GET
    public void longGet(final @Suspended AsyncResponse ar) {
        TASK_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Response processing interrupted", ex);
                }
                ar.resume((Object)SimpleLongRunningResource.NOTIFICATION_RESPONSE);
            }
        });
    }
}

