/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async.managed;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.glassfish.jersey.examples.server.async.managed.Message;
import org.glassfish.jersey.server.ManagedAsync;

@Path(value="chat")
@Produces(value={"application/json"})
public class ChatResource {
    private static final BlockingQueue<AsyncResponse> suspended = new ArrayBlockingQueue<AsyncResponse>(5);

    @GET
    @ManagedAsync
    public void getMessage(@Suspended AsyncResponse ar) throws InterruptedException {
        suspended.put(ar);
    }

    @POST
    @ManagedAsync
    public String postMessage(Message message) throws InterruptedException {
        AsyncResponse asyncResponse = suspended.take();
        asyncResponse.resume((Object)message);
        return "Sent!";
    }
}

