/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.reload.compiler;

import java.util.HashMap;
import java.util.Map;
import org.glassfish.jersey.examples.reload.compiler.ClassFile;

public class AppClassLoader
extends ClassLoader {
    private final Map<String, ClassFile> classFiles = new HashMap<String, ClassFile>();

    public AppClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void setCode(ClassFile cc) {
        this.classFiles.put(cc.getName(), cc);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ClassFile cc = this.classFiles.get(name);
        if (cc == null) {
            return super.findClass(name);
        }
        byte[] byteCode = cc.getByteCode();
        return this.defineClass(name, byteCode, 0, byteCode.length);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassFile cc = this.classFiles.get(name);
        if (cc == null) {
            return super.loadClass(name);
        }
        byte[] byteCode = cc.getByteCode();
        return this.defineClass(name, byteCode, 0, byteCode.length);
    }
}

