/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.opentracing;

import io.opentracing.Span;
import java.util.concurrent.Executors;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.opentracing.OpenTracingUtils;
import org.glassfish.jersey.server.ManagedAsync;
import org.glassfish.jersey.server.Uri;

@Path(value="/resource")
public class TracedResource {
    @GET
    @Path(value="defaultTrace")
    public Response defaultTrace() {
        return Response.ok((Object)"foo").build();
    }

    @GET
    @Path(value="appLevelLogging")
    public Response appLevelLogging(@Context ContainerRequestContext context) throws InterruptedException {
        Span resourceSpan = (Span)OpenTracingUtils.getRequestSpan((ContainerRequestContext)context).orElseThrow(() -> new RuntimeException("Tracing has failed"));
        resourceSpan.log("Starting expensive operation.");
        Thread.sleep(200L);
        resourceSpan.log("Expensive operation finished.");
        resourceSpan.setTag("expensiveOperationSuccess", true);
        return Response.ok((Object)"SUCCESS").build();
    }

    @POST
    @Path(value="appLevelPost")
    public Response tracePost(String entity, @Context ContainerRequestContext context) {
        Span resourceSpan = (Span)OpenTracingUtils.getRequestSpan((ContainerRequestContext)context).orElseThrow(() -> new RuntimeException("Tracing has failed"));
        resourceSpan.setTag("result", "42");
        resourceSpan.setBaggageItem("entity", entity);
        return Response.ok((Object)"Done!").build();
    }

    @GET
    @Path(value="childSpan")
    public Response childSpan(@Context ContainerRequestContext context) throws InterruptedException {
        Span childSpan = OpenTracingUtils.getRequestChildSpan((ContainerRequestContext)context, (String)"AppCreatedSpan");
        childSpan.log("Starting expensive operation.");
        Thread.sleep(200L);
        childSpan.log("Expensive operation finished.");
        childSpan.setTag("expensiveOperationSuccess", true);
        childSpan.finish();
        return Response.ok((Object)"SUCCESS").build();
    }

    @GET
    @Path(value="managedClient")
    public Response traceWithManagedClient(@Context ContainerRequestContext context, @Uri(value="resource/appLevelPost") WebTarget wt) {
        Span providedSpan = (Span)OpenTracingUtils.getRequestSpan((ContainerRequestContext)context).orElseThrow(() -> new RuntimeException("Tracing failed"));
        providedSpan.log("Resource method started.");
        Response response = wt.request().property("span", (Object)providedSpan.context()).post(Entity.text((Object)"Hello"));
        providedSpan.log("1st Response received from managed client");
        providedSpan.log("Firing 1st request from managed client");
        providedSpan.log("Creating child span");
        Span childSpan = OpenTracingUtils.getRequestChildSpan((ContainerRequestContext)context, (String)"jersey-resource-child-span");
        childSpan.log("Firing 2nd request from managed client");
        Response response2 = wt.request().property("span", (Object)childSpan.context()).post(Entity.text((Object)"World"));
        childSpan.log("2st Response received from managed client");
        childSpan.finish();
        return Response.ok((Object)("Result: " + response.getStatus() + ", " + response2.getStatus())).build();
    }

    @GET
    @Path(value="async")
    @ManagedAsync
    public void traceWithAsync(@Suspended AsyncResponse asyncResponse, @Context ContainerRequestContext context) {
        Span span = (Span)OpenTracingUtils.getRequestSpan((ContainerRequestContext)context).orElseThrow(() -> new RuntimeException("tracing failed"));
        span.log("In the resource method.");
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                span.log("Interrupted");
                e.printStackTrace();
            }
            span.log("Resuming");
            asyncResponse.resume((Object)"OK");
        });
        span.log("Before exiting the resource method");
    }

    @GET
    @Path(value="error")
    public String failTrace(@Context ContainerRequestContext context) {
        throw new RuntimeException("Failing just for fun.");
    }
}

