/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.helloworld.netty;

import io.netty.channel.Channel;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.examples.helloworld.netty.HelloWorldResource;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainerProvider;
import org.glassfish.jersey.server.ResourceConfig;

public class App {
    static final String ROOT_PATH = "helloworld";
    private static final URI BASE_URI = URI.create("http://localhost:8080/");

    public static void main(String[] args) {
        try {
            System.out.println("\"Hello World\" Jersey Example App on Netty container.");
            ResourceConfig resourceConfig = new ResourceConfig(new Class[]{HelloWorldResource.class});
            final Channel server = NettyHttpContainerProvider.createHttp2Server((URI)BASE_URI, (ResourceConfig)resourceConfig, null);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    server.close();
                }
            }));
            System.out.println(String.format("Application started. (HTTP/2 enabled!)\nTry out %s%s\nStop the application using CTRL+C.", BASE_URI, ROOT_PATH));
            Thread.currentThread().join();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

