/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.linking.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Produces;
import org.glassfish.jersey.examples.linking.model.ItemModel;
import org.glassfish.jersey.examples.linking.model.ItemsModel;
import org.glassfish.jersey.examples.linking.representation.ItemRepresentation;

@Produces(value={"application/xml", "application/json"})
public class ItemResource {
    private ItemsModel itemsModel;
    private ItemModel itemModel;
    private String id;

    public ItemResource() {
        throw new IllegalStateException("Only for JAX-B dressing");
    }

    public ItemResource(ItemsModel itemsModel, String id) {
        this.id = id;
        this.itemsModel = itemsModel;
        try {
            this.itemModel = itemsModel.getItem(id);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new NotFoundException();
        }
    }

    @GET
    public ItemRepresentation get() {
        return new ItemRepresentation(this.itemsModel, this.id, this.itemModel.getName());
    }

    public String getId() {
        return this.id;
    }
}

